/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jvmmonitor.metric;

import com.eg.agent.JavaVersion;
import com.eg.jtm.BTMLog;
import com.eg.jtm.JVMConfig;
import com.eg.jvmmonitor.JVMMetric;
import com.eg.jvmmonitor.utils.JVMUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.management.JMRuntimeException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public class JVMThreadInfo
extends JVMMetric {
    private boolean isOracleHotSpotVersion6u25 = false;
    private boolean isOracleHotSpotVersion6u25found = false;
    private boolean isOracleHotSpotVersion9 = false;
    private boolean isSap6orJrockitVersionb37 = false;
    private boolean isSapResult = false;
    private boolean isJreAbove6 = false;

    public JVMThreadInfo() {
        JavaVersion javaVersion = JavaVersion.getJavaVersion();
        switch (javaVersion) {
            case JAVA_9: 
            case JAVA_10: 
            case JAVA_11: 
            case ABOVE_11: {
                this.isOracleHotSpotVersion9 = true;
                this.isJreAbove6 = true;
                break;
            }
            case JAVA_6: {
                this.isJreAbove6 = true;
                this.isOracleHotSpotVersion9 = false;
                if (!this.isSaporJRockitVendor()) break;
                this.isSap6orJrockitVersionb37 = this.isSap6orJRockitVersionBelow37();
                break;
            }
            case JAVA_5: {
                this.isJreAbove6 = false;
                this.isOracleHotSpotVersion9 = false;
            }
        }
    }

    private boolean isSaporJRockitVendor() {
        boolean bl = false;
        this.isSapResult = false;
        String string = System.getProperty("java.vm.name");
        if (string != null) {
            if ((string = string.toLowerCase()).indexOf("jrockit") > -1) {
                bl = true;
            } else if (string.indexOf("sap") > -1) {
                bl = true;
                this.isSapResult = true;
            }
        }
        return bl;
    }

    private boolean isSap6orJRockitVersionBelow37() {
        StringTokenizer stringTokenizer;
        int n;
        boolean bl = false;
        String string = System.getProperty("java.version");
        if (string != null && string.length() > 0 && (n = (stringTokenizer = new StringTokenizer(string, ".")).countTokens()) >= 2) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string3);
            if (n2 == 6) {
                if (this.isSapResult) {
                    bl = true;
                    return bl;
                }
                if (n >= 3) {
                    String string4 = stringTokenizer.nextToken();
                    int n3 = string4.indexOf("_");
                    if (n3 > 0) {
                        int n4;
                        String string5 = string4.substring(n3 + 1);
                        if (string5 != null && string5.length() > 0 && (n4 = Integer.parseInt(string5 = string5.trim())) < 37) {
                            bl = true;
                        }
                    } else {
                        bl = true;
                    }
                }
            }
        }
        return bl;
    }

    public ArrayList pollMeasures() {
        Object[] objectArray;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        ArrayList<Hashtable<String, Object>> arrayList = new ArrayList<Hashtable<String, Object>>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        MBeanServerConnection mBeanServerConnection = JVMUtils.getMbeanServerConnection();
        if (mBeanServerConnection == null) {
            return arrayList;
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        try {
            if (threadMXBean.isThreadCpuTimeSupported()) {
                if (!threadMXBean.isThreadCpuTimeEnabled()) {
                    threadMXBean.setThreadCpuTimeEnabled(true);
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        try {
            if (threadMXBean.isThreadContentionMonitoringSupported()) {
                if (!threadMXBean.isThreadContentionMonitoringEnabled()) {
                    threadMXBean.setThreadContentionMonitoringEnabled(true);
                }
                bl2 = true;
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        int n = threadMXBean.getThreadCount();
        int n2 = JVMConfig.getThreadDumpLimit();
        boolean bl4 = false;
        if (n2 != -1) {
            bl4 = true;
            if (n <= n2) {
                n2 = -1;
                bl4 = false;
            }
        }
        ObjectName objectName = null;
        try {
            objectName = new ObjectName("java.lang:type=Threading");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            BTMLog.logger.warn("Malformed ObjectName {} java.lang:type=Threading");
        }
        Hashtable hashtable2 = new Hashtable();
        Hashtable<Object, Long> hashtable3 = null;
        Hashtable<Object, Object> hashtable4 = new Hashtable<Object, Object>();
        if (n2 == -1) {
            if (this.isJreAbove6) {
                Object object;
                objectArray = null;
                try {
                    objectArray = (CompositeData[])mBeanServerConnection.invoke(objectName, "dumpAllThreads", new Object[]{new Boolean(true), new Boolean(true)}, new String[]{"boolean", "boolean"});
                }
                catch (SecurityException securityException) {
                    BTMLog.logger.error(" [JVMThreadInfo] :[dumpAllThreads] security manager exists and the caller does not have ManagementPermission(\"monitor\")");
                    bl3 = true;
                }
                catch (JMRuntimeException jMRuntimeException) {
                    object = jMRuntimeException.getMessage();
                    if (object != null && ((String)object).indexOf("Unauthorized access") > 0) {
                        BTMLog.logger.error("[JVMThreadInfo] :[dumpAllThreads] Unauthorized access. User does not have required permission ");
                        bl3 = true;
                    } else {
                        BTMLog.logger.error("[JVMThreadInfo] Exception occured while invoking dump all threads ... {}", (Object)jMRuntimeException.getMessage());
                    }
                }
                catch (Exception exception) {
                    BTMLog.logger.error("[JVMThreadInfo] Exception occured while invoking dump all threads ... {}", (Object)exception.getMessage());
                }
                if (this.isSap6orJrockitVersionb37) {
                    if (bl && !bl3) {
                        hashtable3 = this.getAllThreadCpuTimeBelow6u25(mBeanServerConnection);
                    }
                } else {
                    hashtable3 = this.getAllThreadCpuTime(bl, bl3, mBeanServerConnection);
                }
                if (objectArray != null && objectArray.length > 0) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object2;
                        object = objectArray[i];
                        if (object == null || (object2 = object.get("threadId")) == null) continue;
                        hashtable4.put(object2, object);
                    }
                    hashtable2.put("threadData", hashtable4);
                }
            } else {
                objectArray = threadMXBean.getAllThreadIds();
                for (int i = 0; i < objectArray.length; ++i) {
                    long l = objectArray[i];
                    try {
                        Object object;
                        CompositeData compositeData = null;
                        try {
                            compositeData = (CompositeData)mBeanServerConnection.invoke(objectName, "getThreadInfo", new Object[]{new Long(objectArray[i]), new Integer(Integer.MAX_VALUE)}, new String[]{"long", "int"});
                        }
                        catch (Exception exception) {
                            BTMLog.logger.error("[JVMThreadTest]- Exception occured while fetching composite data  :" + exception.getMessage());
                        }
                        if (compositeData == null || (object = compositeData.get("threadId")) == null) continue;
                        hashtable4.put(object, compositeData);
                        continue;
                    }
                    catch (SecurityException securityException) {
                        BTMLog.logger.error("[JVMThreadTest]- Exception occured  :[getThreadInfo] security manager exists and the caller does not have ManagementPermission(\"monitor\") ");
                        bl3 = true;
                        continue;
                    }
                    catch (Exception exception) {
                        BTMLog.logger.error("[JVMThreadInfo] Excetion occured for the ID :" + l + " message : " + exception.getMessage());
                    }
                }
                hashtable2.put("threadData", hashtable4);
                if (bl && !bl3) {
                    hashtable3 = this.getAllThreadCpuTimeBelow6u25(mBeanServerConnection);
                }
            }
        }
        objectArray = null;
        try {
            Long l;
            Object object;
            int n3 = threadMXBean.getPeakThreadCount();
            long l2 = threadMXBean.getTotalStartedThreadCount();
            int n4 = threadMXBean.getDaemonThreadCount();
            if (!bl3) {
                try {
                    objectArray = this.isJreAbove6 ? threadMXBean.findDeadlockedThreads() : threadMXBean.findMonitorDeadlockedThreads();
                    if (objectArray != null && objectArray.length > 0) {
                        Arrays.sort(objectArray);
                    }
                }
                catch (SecurityException securityException) {
                    BTMLog.logger.error(" [JVMThreadTest]- Exception occured :[findDeadlockedThreads] security manager exists and the caller does not have ManagementPermission(\"monitor\") ");
                    bl3 = true;
                }
                catch (Exception exception) {
                    BTMLog.logger.error(" [JVMThreadTest]- Exception occured :[findDeadlockedThreads] {} ", (Object)exception.getMessage());
                }
                if (n2 != -1 && !bl3 && objectArray != null && objectArray.length > 0) {
                    hashtable3 = new Hashtable<Object, Long>();
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object3;
                        object = null;
                        long l3 = objectArray[i];
                        try {
                            object = (CompositeData)mBeanServerConnection.invoke(objectName, "getThreadInfo", new Object[]{new Long(l3), new Integer(Integer.MAX_VALUE)}, new String[]{"long", "int"});
                        }
                        catch (Exception exception) {
                            BTMLog.logger.error(" [JVMThreadTest]- Exception occured while fetching the composite data : " + exception.getMessage());
                        }
                        if (object == null || (object3 = object.get("threadId")) == null) continue;
                        hashtable4.put(object3, object);
                        long l4 = threadMXBean.getThreadCpuTime(l3);
                        hashtable3.put(object3, new Long(l4));
                    }
                    hashtable2.put("threadData", hashtable4);
                }
            }
            int n5 = JVMUtils.getAvilableProcessor();
            object = runtimeMXBean.getName();
            if (hashtable3 != null) {
                hashtable.put("allCPUtimeTable", hashtable3);
            }
            if ((l = JVMUtils.getProcessCpuTime()) == null) {
                l = new Long(0L);
            }
            hashtable.put("processtime", l);
            hashtable.put("isIBMJvm", JVMUtils.isIBMJVM());
            n = threadMXBean.getThreadCount();
            long l5 = runtimeMXBean.getUptime();
            hashtable.put("ThreadValues", hashtable2);
            hashtable.put("totalThreadCount", n);
            hashtable.put("peakThreadCount", n3);
            hashtable.put("daemonThreadCount", n4);
            hashtable.put("totalStartedThreadCount", l2);
            hashtable.put("isCpuTimeEnabled", bl);
            hashtable.put("isContentionMonitoringEnabled", bl2);
            hashtable.put("uptime4Thread", new Long(l5));
            hashtable.put("availableProcessor", n5);
            hashtable.put("threadpidName", new String((String)object));
            hashtable.put("dumpLimitCrossed", bl4);
            if (objectArray != null) {
                hashtable.put("DeadLockThreadIds", objectArray);
            }
            hashtable.put("isOracleJavaAbove9", this.isOracleHotSpotVersion9);
            hashtable.put("securityException", bl3);
        }
        catch (Exception exception) {
            BTMLog.logger.error("[JVMThreadInfo] - Exception occured. " + exception.getMessage());
        }
        arrayList.add(hashtable);
        BTMLog.logger.trace("[JVMThreadInfo] - result. " + arrayList.size());
        return arrayList;
    }

    private Hashtable getAllThreadCpuTimeBelow6u25(MBeanServerConnection mBeanServerConnection) {
        Hashtable<Object, Long> hashtable = new Hashtable<Object, Long>();
        try {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            ObjectName objectName = new ObjectName("java.lang:type=Threading");
            long[] lArray = threadMXBean.getAllThreadIds();
            for (int i = 0; i < lArray.length; ++i) {
                long l = lArray[i];
                try {
                    Object object;
                    CompositeData compositeData = null;
                    try {
                        compositeData = (CompositeData)mBeanServerConnection.invoke(objectName, "getThreadInfo", new Object[]{new Long(lArray[i]), new Integer(0)}, new String[]{"long", "int"});
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (compositeData == null || (object = compositeData.get("threadId")) == null) continue;
                    try {
                        long l2 = threadMXBean.getThreadCpuTime(l);
                        hashtable.put(object, l2);
                    }
                    catch (Exception exception) {
                        BTMLog.logger.error("[JVMThreadTest]- Exception occured while fetching the cpu time for each thread : " + exception.getMessage());
                    }
                    continue;
                }
                catch (SecurityException securityException) {
                    BTMLog.logger.error("[JVMThreadTest]- Exception occured  :[getThreadInfo] security manager exists and the caller does not have ManagementPermission(\"monitor\") ");
                    break;
                }
                catch (Exception exception) {
                    BTMLog.logger.error("[JVMThreadInfo] Exception occured for the ID :" + l + " message : " + exception.getMessage());
                }
            }
        }
        catch (Exception exception) {
            BTMLog.logger.error("[JVMThreadTest]- Exception occured in the method getAllThreadCpuTime4Below6" + exception.getMessage());
        }
        return hashtable;
    }

    private Hashtable getAllThreadCpuTime(boolean bl, boolean bl2, MBeanServerConnection mBeanServerConnection) {
        if (!bl || bl2) {
            return null;
        }
        Hashtable hashtable = null;
        if (this.isOracleHotSpotVersion6u25found && !this.isOracleHotSpotVersion6u25) {
            BTMLog.logger.debug(" JRE version is above 6 , but below 6u25 " + this.isOracleHotSpotVersion6u25found + "  " + this.isOracleHotSpotVersion6u25);
            hashtable = this.getAllThreadCpuTimeBelow6u25(mBeanServerConnection);
            return hashtable;
        }
        hashtable = new Hashtable();
        try {
            com.sun.management.ThreadMXBean threadMXBean = ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, "java.lang:type=Threading", com.sun.management.ThreadMXBean.class);
            long[] lArray = null;
            long[] lArray2 = null;
            try {
                lArray = threadMXBean.getAllThreadIds();
                lArray2 = threadMXBean.getThreadCpuTime(lArray);
            }
            catch (Exception exception) {
                BTMLog.logger.error(" [JVMThreadTest]- Exception occured : in the method getAllThreadCpuTime");
            }
            if (lArray != null && lArray2 != null) {
                for (int i = 0; i < lArray.length; ++i) {
                    Long l = new Long(lArray2[i]);
                    Long l2 = new Long(lArray[i]);
                    hashtable.put(l2, l);
                }
                this.isOracleHotSpotVersion6u25found = true;
                this.isOracleHotSpotVersion6u25 = true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            BTMLog.logger.error("Inside [getAllThreadCpuTime] - IllegalArgumentException " + illegalArgumentException.getMessage());
            this.isOracleHotSpotVersion6u25found = true;
            this.isOracleHotSpotVersion6u25 = false;
        }
        catch (Throwable throwable) {
            this.isOracleHotSpotVersion6u25found = false;
            this.isOracleHotSpotVersion6u25 = false;
        }
        if (this.isOracleHotSpotVersion6u25found && !this.isOracleHotSpotVersion6u25) {
            hashtable = this.getAllThreadCpuTimeBelow6u25(mBeanServerConnection);
        }
        return hashtable;
    }
}

