/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.UndeclaredThrowableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Functions {
    public static <T extends Throwable> void run(FailableRunnable<T> failableRunnable) {
        try {
            failableRunnable.run();
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O, T extends Throwable> O call(FailableCallable<O, T> failableCallable) {
        try {
            return failableCallable.call();
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O, T extends Throwable> void accept(FailableConsumer<O, T> failableConsumer, O o) {
        try {
            failableConsumer.accept(o);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O1, O2, T extends Throwable> void accept(FailableBiConsumer<O1, O2, T> failableBiConsumer, O1 O1, O2 O2) {
        try {
            failableBiConsumer.accept(O1, O2);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <I, O, T extends Throwable> O apply(FailableFunction<I, O, T> failableFunction, I i) {
        try {
            return failableFunction.apply(i);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <I1, I2, O, T extends Throwable> O apply(FailableBiFunction<I1, I2, O, T> failableBiFunction, I1 I1, I2 I2) {
        try {
            return failableBiFunction.apply(I1, I2);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O, T extends Throwable> boolean test(FailablePredicate<O, T> failablePredicate, O o) {
        try {
            return failablePredicate.test(o);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    public static <O1, O2, T extends Throwable> boolean test(FailableBiPredicate<O1, O2, T> failableBiPredicate, O1 O1, O2 O2) {
        try {
            return failableBiPredicate.test(O1, O2);
        }
        catch (Throwable throwable) {
            throw Functions.rethrow(throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> failableRunnable, FailableConsumer<Throwable, ? extends Throwable> failableConsumer, FailableRunnable<? extends Throwable> ... failableRunnableArray) {
        void var4_8;
        FailableConsumer<Throwable, Throwable> failableConsumer2 = failableConsumer == null ? new FailableConsumer<Throwable, Throwable>(){

            @Override
            public void accept(Throwable throwable) throws Throwable {
                Functions.rethrow(throwable);
            }
        } : failableConsumer;
        if (failableRunnableArray != null) {
            for (FailableRunnable<? extends Throwable> failableRunnable2 : failableRunnableArray) {
                if (failableRunnable2 != null) continue;
                throw new NullPointerException("A resource action must not be null.");
            }
        }
        Object var4_5 = null;
        try {
            failableRunnable.run();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
        }
        if (failableRunnableArray != null) {
            for (FailableRunnable<? extends Throwable> failableRunnable3 : failableRunnableArray) {
                try {
                    failableRunnable3.run();
                }
                catch (Throwable throwable) {
                    if (var4_8 != null) continue;
                    Throwable throwable3 = throwable;
                }
            }
        }
        if (var4_8 != null) {
            try {
                failableConsumer2.accept((Throwable)var4_8);
            }
            catch (Throwable throwable) {
                throw Functions.rethrow(throwable);
            }
        }
    }

    @SafeVarargs
    public static void tryWithResources(FailableRunnable<? extends Throwable> failableRunnable, FailableRunnable<? extends Throwable> ... failableRunnableArray) {
        Functions.tryWithResources(failableRunnable, null, failableRunnableArray);
    }

    public static RuntimeException rethrow(Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("The Throwable must not be null.");
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof IOException) {
            throw new UncheckedIOException((IOException)throwable);
        }
        throw new UndeclaredThrowableException(throwable);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @FunctionalInterface
    public static interface FailableBiPredicate<O1, O2, T extends Throwable> {
        public boolean test(O1 var1, O2 var2) throws T;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @FunctionalInterface
    public static interface FailablePredicate<O, T extends Throwable> {
        public boolean test(O var1) throws T;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @FunctionalInterface
    public static interface FailableBiFunction<I1, I2, O, T extends Throwable> {
        public O apply(I1 var1, I2 var2) throws T;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @FunctionalInterface
    public static interface FailableFunction<I, O, T extends Throwable> {
        public O apply(I var1) throws T;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @FunctionalInterface
    public static interface FailableBiConsumer<O1, O2, T extends Throwable> {
        public void accept(O1 var1, O2 var2) throws T;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @FunctionalInterface
    public static interface FailableConsumer<O, T extends Throwable> {
        public void accept(O var1) throws T;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @FunctionalInterface
    public static interface FailableCallable<O, T extends Throwable> {
        public O call() throws T;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @FunctionalInterface
    public static interface FailableRunnable<T extends Throwable> {
        public void run() throws T;
    }
}

