/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm;

import com.eg.org.objectweb.asm.AnnotationVisitor;
import com.eg.org.objectweb.asm.AnnotationWriter;
import com.eg.org.objectweb.asm.Attribute;
import com.eg.org.objectweb.asm.ByteVector;
import com.eg.org.objectweb.asm.ClassReader;
import com.eg.org.objectweb.asm.CurrentFrame;
import com.eg.org.objectweb.asm.Edge;
import com.eg.org.objectweb.asm.Frame;
import com.eg.org.objectweb.asm.Handle;
import com.eg.org.objectweb.asm.Handler;
import com.eg.org.objectweb.asm.Label;
import com.eg.org.objectweb.asm.MethodTooLargeException;
import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.Opcodes;
import com.eg.org.objectweb.asm.Symbol;
import com.eg.org.objectweb.asm.SymbolTable;
import com.eg.org.objectweb.asm.Type;
import com.eg.org.objectweb.asm.TypePath;
import com.eg.org.objectweb.asm.TypeReference;

final class MethodWriter
extends MethodVisitor {
    static final int COMPUTE_NOTHING = 0;
    static final int COMPUTE_MAX_STACK_AND_LOCAL = 1;
    static final int COMPUTE_MAX_STACK_AND_LOCAL_FROM_FRAMES = 2;
    static final int COMPUTE_INSERTED_FRAMES = 3;
    static final int COMPUTE_ALL_FRAMES = 4;
    private static final int NA = 0;
    private static final int[] STACK_SIZE_DELTA = new int[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 2, 1, 1, 1, 0, 0, 1, 2, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, -1, 0, -1, -1, -1, -1, -1, -2, -1, -2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -3, -4, -3, -4, -3, -3, -3, -3, -1, -2, 1, 1, 1, 2, 2, 2, 0, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, -1, -2, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -2, -1, -2, -1, -2, 0, 1, 0, 1, -1, -1, 0, 0, 1, 1, -1, 0, -1, 0, 0, 0, -3, -1, -1, -3, -3, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, 0, 1, 0, -1, -1, -1, -2, -1, -2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, -1, -1, 0, 0};
    private final SymbolTable symbolTable;
    private final int accessFlags;
    private final int nameIndex;
    private final String name;
    private final int descriptorIndex;
    private final String descriptor;
    private int maxStack;
    private int maxLocals;
    private final ByteVector code = new ByteVector();
    private Handler firstHandler;
    private Handler lastHandler;
    private int lineNumberTableLength;
    private ByteVector lineNumberTable;
    private int localVariableTableLength;
    private ByteVector localVariableTable;
    private int localVariableTypeTableLength;
    private ByteVector localVariableTypeTable;
    private int stackMapTableNumberOfEntries;
    private ByteVector stackMapTableEntries;
    private AnnotationWriter lastCodeRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastCodeRuntimeInvisibleTypeAnnotation;
    private Attribute firstCodeAttribute;
    private final int numberOfExceptions;
    private final int[] exceptionIndexTable;
    private final int signatureIndex;
    private AnnotationWriter lastRuntimeVisibleAnnotation;
    private AnnotationWriter lastRuntimeInvisibleAnnotation;
    private int visibleAnnotableParameterCount;
    private AnnotationWriter[] lastRuntimeVisibleParameterAnnotations;
    private int invisibleAnnotableParameterCount;
    private AnnotationWriter[] lastRuntimeInvisibleParameterAnnotations;
    private AnnotationWriter lastRuntimeVisibleTypeAnnotation;
    private AnnotationWriter lastRuntimeInvisibleTypeAnnotation;
    private ByteVector defaultValue;
    private int parametersCount;
    private ByteVector parameters;
    private Attribute firstAttribute;
    private final int compute;
    private Label firstBasicBlock;
    private Label lastBasicBlock;
    private Label currentBasicBlock;
    private int relativeStackSize;
    private int maxRelativeStackSize;
    private int currentLocals;
    private int previousFrameOffset;
    private int[] previousFrame;
    private int[] currentFrame;
    private boolean hasSubroutines;
    private boolean hasAsmInstructions;
    private int lastBytecodeOffset;
    private int sourceOffset;
    private int sourceLength;

    MethodWriter(SymbolTable symbolTable, int n, String string, String string2, String string3, String[] stringArray, int n2) {
        super(458752);
        int n3;
        this.symbolTable = symbolTable;
        this.accessFlags = "<init>".equals(string) ? n | 0x40000 : n;
        this.nameIndex = symbolTable.addConstantUtf8(string);
        this.name = string;
        this.descriptorIndex = symbolTable.addConstantUtf8(string2);
        this.descriptor = string2;
        int n4 = this.signatureIndex = string3 == null ? 0 : symbolTable.addConstantUtf8(string3);
        if (stringArray != null && stringArray.length > 0) {
            this.numberOfExceptions = stringArray.length;
            this.exceptionIndexTable = new int[this.numberOfExceptions];
            for (n3 = 0; n3 < this.numberOfExceptions; ++n3) {
                this.exceptionIndexTable[n3] = symbolTable.addConstantClass((String)stringArray[n3]).index;
            }
        } else {
            this.numberOfExceptions = 0;
            this.exceptionIndexTable = null;
        }
        this.compute = n2;
        if (n2 != 0) {
            n3 = Type.getArgumentsAndReturnSizes(string2) >> 2;
            if ((n & 8) != 0) {
                --n3;
            }
            this.maxLocals = n3;
            this.currentLocals = n3;
            this.firstBasicBlock = new Label();
            this.visitLabel(this.firstBasicBlock);
        }
    }

    boolean hasFrames() {
        return this.stackMapTableNumberOfEntries > 0;
    }

    boolean hasAsmInstructions() {
        return this.hasAsmInstructions;
    }

    public void visitParameter(String string, int n) {
        if (this.parameters == null) {
            this.parameters = new ByteVector();
        }
        ++this.parametersCount;
        this.parameters.putShort(string == null ? 0 : this.symbolTable.addConstantUtf8(string)).putShort(n);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        this.defaultValue = new ByteVector();
        return new AnnotationWriter(this.symbolTable, false, this.defaultValue, null);
    }

    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(this.symbolTable.addConstantUtf8(string)).putShort(0);
        if (bl) {
            this.lastRuntimeVisibleAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeVisibleAnnotation);
            return this.lastRuntimeVisibleAnnotation;
        }
        this.lastRuntimeInvisibleAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeInvisibleAnnotation);
        return this.lastRuntimeInvisibleAnnotation;
    }

    public AnnotationVisitor visitTypeAnnotation(int n, TypePath typePath, String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        TypeReference.putTarget(n, byteVector);
        TypePath.put(typePath, byteVector);
        byteVector.putShort(this.symbolTable.addConstantUtf8(string)).putShort(0);
        if (bl) {
            this.lastRuntimeVisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeVisibleTypeAnnotation);
            return this.lastRuntimeVisibleTypeAnnotation;
        }
        this.lastRuntimeInvisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeInvisibleTypeAnnotation);
        return this.lastRuntimeInvisibleTypeAnnotation;
    }

    public void visitAnnotableParameterCount(int n, boolean bl) {
        if (bl) {
            this.visibleAnnotableParameterCount = n;
        } else {
            this.invisibleAnnotableParameterCount = n;
        }
    }

    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(this.symbolTable.addConstantUtf8(string)).putShort(0);
        if (bl) {
            if (this.lastRuntimeVisibleParameterAnnotations == null) {
                this.lastRuntimeVisibleParameterAnnotations = new AnnotationWriter[Type.getArgumentTypes(this.descriptor).length];
            }
            this.lastRuntimeVisibleParameterAnnotations[n] = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeVisibleParameterAnnotations[n]);
            return this.lastRuntimeVisibleParameterAnnotations[n];
        }
        if (this.lastRuntimeInvisibleParameterAnnotations == null) {
            this.lastRuntimeInvisibleParameterAnnotations = new AnnotationWriter[Type.getArgumentTypes(this.descriptor).length];
        }
        this.lastRuntimeInvisibleParameterAnnotations[n] = new AnnotationWriter(this.symbolTable, byteVector, this.lastRuntimeInvisibleParameterAnnotations[n]);
        return this.lastRuntimeInvisibleParameterAnnotations[n];
    }

    public void visitAttribute(Attribute attribute) {
        if (attribute.isCodeAttribute()) {
            attribute.nextAttribute = this.firstCodeAttribute;
            this.firstCodeAttribute = attribute;
        } else {
            attribute.nextAttribute = this.firstAttribute;
            this.firstAttribute = attribute;
        }
    }

    public void visitCode() {
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        int n4;
        int n5;
        if (this.compute == 4) {
            return;
        }
        if (this.compute == 3) {
            if (this.currentBasicBlock.frame == null) {
                this.currentBasicBlock.frame = new CurrentFrame(this.currentBasicBlock);
                this.currentBasicBlock.frame.setInputFrameFromDescriptor(this.symbolTable, this.accessFlags, this.descriptor, n2);
                this.currentBasicBlock.frame.accept(this);
            } else {
                if (n == -1) {
                    this.currentBasicBlock.frame.setInputFrameFromApiFormat(this.symbolTable, n2, objectArray, n3, objectArray2);
                }
                this.currentBasicBlock.frame.accept(this);
            }
        } else if (n == -1) {
            if (this.previousFrame == null) {
                n5 = Type.getArgumentsAndReturnSizes(this.descriptor) >> 2;
                Frame frame = new Frame(new Label());
                frame.setInputFrameFromDescriptor(this.symbolTable, this.accessFlags, this.descriptor, n5);
                frame.accept(this);
            }
            this.currentLocals = n2;
            n5 = this.visitFrameStart(this.code.length, n2, n3);
            for (n4 = 0; n4 < n2; ++n4) {
                this.currentFrame[n5++] = Frame.getAbstractTypeFromApiFormat(this.symbolTable, objectArray[n4]);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                this.currentFrame[n5++] = Frame.getAbstractTypeFromApiFormat(this.symbolTable, objectArray2[n4]);
            }
            this.visitFrameEnd();
        } else {
            if (this.stackMapTableEntries == null) {
                this.stackMapTableEntries = new ByteVector();
                n5 = this.code.length;
            } else {
                n5 = this.code.length - this.previousFrameOffset - 1;
                if (n5 < 0) {
                    if (n == 3) {
                        return;
                    }
                    throw new IllegalStateException();
                }
            }
            switch (n) {
                case 0: {
                    this.currentLocals = n2;
                    this.stackMapTableEntries.putByte(255).putShort(n5).putShort(n2);
                    for (n4 = 0; n4 < n2; ++n4) {
                        this.putFrameType(objectArray[n4]);
                    }
                    this.stackMapTableEntries.putShort(n3);
                    for (n4 = 0; n4 < n3; ++n4) {
                        this.putFrameType(objectArray2[n4]);
                    }
                    break;
                }
                case 1: {
                    this.currentLocals += n2;
                    this.stackMapTableEntries.putByte(251 + n2).putShort(n5);
                    for (n4 = 0; n4 < n2; ++n4) {
                        this.putFrameType(objectArray[n4]);
                    }
                    break;
                }
                case 2: {
                    this.currentLocals -= n2;
                    this.stackMapTableEntries.putByte(251 - n2).putShort(n5);
                    break;
                }
                case 3: {
                    if (n5 < 64) {
                        this.stackMapTableEntries.putByte(n5);
                        break;
                    }
                    this.stackMapTableEntries.putByte(251).putShort(n5);
                    break;
                }
                case 4: {
                    if (n5 < 64) {
                        this.stackMapTableEntries.putByte(64 + n5);
                    } else {
                        this.stackMapTableEntries.putByte(247).putShort(n5);
                    }
                    this.putFrameType(objectArray2[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.previousFrameOffset = this.code.length;
            ++this.stackMapTableNumberOfEntries;
        }
        if (this.compute == 2) {
            this.relativeStackSize = n3;
            for (n5 = 0; n5 < n3; ++n5) {
                if (objectArray2[n5] != Opcodes.LONG && objectArray2[n5] != Opcodes.DOUBLE) continue;
                ++this.relativeStackSize;
            }
            if (this.relativeStackSize > this.maxRelativeStackSize) {
                this.maxRelativeStackSize = this.relativeStackSize;
            }
        }
        this.maxStack = Math.max(this.maxStack, n3);
        this.maxLocals = Math.max(this.maxLocals, this.currentLocals);
    }

    public void visitInsn(int n) {
        this.lastBytecodeOffset = this.code.length;
        this.code.putByte(n);
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n, 0, null, null);
            } else {
                int n2 = this.relativeStackSize + STACK_SIZE_DELTA[n];
                if (n2 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n2;
                }
                this.relativeStackSize = n2;
            }
            if (n >= 172 && n <= 177 || n == 191) {
                this.endCurrentBasicBlockWithNoSuccessor();
            }
        }
    }

    public void visitIntInsn(int n, int n2) {
        this.lastBytecodeOffset = this.code.length;
        if (n == 17) {
            this.code.put12(n, n2);
        } else {
            this.code.put11(n, n2);
        }
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n, n2, null, null);
            } else if (n != 188) {
                int n3 = this.relativeStackSize + 1;
                if (n3 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n3;
                }
                this.relativeStackSize = n3;
            }
        }
    }

    public void visitVarInsn(int n, int n2) {
        int n3;
        this.lastBytecodeOffset = this.code.length;
        if (n2 < 4 && n != 169) {
            n3 = n < 54 ? 26 + (n - 21 << 2) + n2 : 59 + (n - 54 << 2) + n2;
            this.code.putByte(n3);
        } else if (n2 >= 256) {
            this.code.putByte(196).put12(n, n2);
        } else {
            this.code.put11(n, n2);
        }
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n, n2, null, null);
            } else if (n == 169) {
                this.currentBasicBlock.flags = (short)(this.currentBasicBlock.flags | 0x40);
                this.currentBasicBlock.outputStackSize = (short)this.relativeStackSize;
                this.endCurrentBasicBlockWithNoSuccessor();
            } else {
                n3 = this.relativeStackSize + STACK_SIZE_DELTA[n];
                if (n3 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n3;
                }
                this.relativeStackSize = n3;
            }
        }
        if (this.compute != 0 && (n3 = n == 22 || n == 24 || n == 55 || n == 57 ? n2 + 2 : n2 + 1) > this.maxLocals) {
            this.maxLocals = n3;
        }
        if (n >= 54 && this.compute == 4 && this.firstHandler != null) {
            this.visitLabel(new Label());
        }
    }

    public void visitTypeInsn(int n, String string) {
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstantClass(string);
        this.code.put12(n, symbol.index);
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n, this.lastBytecodeOffset, symbol, this.symbolTable);
            } else if (n == 187) {
                int n2 = this.relativeStackSize + 1;
                if (n2 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n2;
                }
                this.relativeStackSize = n2;
            }
        }
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstantFieldref(string, string2, string3);
        this.code.put12(n, symbol.index);
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n, 0, symbol, this.symbolTable);
            } else {
                int n2;
                char c = string3.charAt(0);
                switch (n) {
                    case 178: {
                        n2 = this.relativeStackSize + (c == 'D' || c == 'J' ? 2 : 1);
                        break;
                    }
                    case 179: {
                        n2 = this.relativeStackSize + (c == 'D' || c == 'J' ? -2 : -1);
                        break;
                    }
                    case 180: {
                        n2 = this.relativeStackSize + (c == 'D' || c == 'J' ? 1 : 0);
                        break;
                    }
                    default: {
                        n2 = this.relativeStackSize + (c == 'D' || c == 'J' ? -3 : -2);
                    }
                }
                if (n2 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n2;
                }
                this.relativeStackSize = n2;
            }
        }
    }

    public void visitMethodInsn(int n, String string, String string2, String string3, boolean bl) {
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstantMethodref(string, string2, string3, bl);
        if (n == 185) {
            this.code.put12(185, symbol.index).put11(symbol.getArgumentsAndReturnSizes() >> 2, 0);
        } else {
            this.code.put12(n, symbol.index);
        }
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(n, 0, symbol, this.symbolTable);
            } else {
                int n2 = symbol.getArgumentsAndReturnSizes();
                int n3 = (n2 & 3) - (n2 >> 2);
                int n4 = n == 184 ? this.relativeStackSize + n3 + 1 : this.relativeStackSize + n3;
                if (n4 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n4;
                }
                this.relativeStackSize = n4;
            }
        }
    }

    public void visitInvokeDynamicInsn(String string, String string2, Handle handle, Object ... objectArray) {
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstantInvokeDynamic(string, string2, handle, objectArray);
        this.code.put12(186, symbol.index);
        this.code.putShort(0);
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(186, 0, symbol, this.symbolTable);
            } else {
                int n = symbol.getArgumentsAndReturnSizes();
                int n2 = (n & 3) - (n >> 2) + 1;
                int n3 = this.relativeStackSize + n2;
                if (n3 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n3;
                }
                this.relativeStackSize = n3;
            }
        }
    }

    public void visitJumpInsn(int n, Label label) {
        this.lastBytecodeOffset = this.code.length;
        int n2 = n >= 200 ? n - 33 : n;
        boolean bl = false;
        if ((label.flags & 4) != 0 && label.bytecodeOffset - this.code.length < Short.MIN_VALUE) {
            if (n2 == 167) {
                this.code.putByte(200);
            } else if (n2 == 168) {
                this.code.putByte(201);
            } else {
                this.code.putByte(n2 >= 198 ? n2 ^ 1 : (n2 + 1 ^ 1) - 1);
                this.code.putShort(8);
                this.code.putByte(220);
                this.hasAsmInstructions = true;
                bl = true;
            }
            label.put(this.code, this.code.length - 1, true);
        } else if (n2 != n) {
            this.code.putByte(n);
            label.put(this.code, this.code.length - 1, true);
        } else {
            this.code.putByte(n2);
            label.put(this.code, this.code.length - 1, false);
        }
        if (this.currentBasicBlock != null) {
            Label label2 = null;
            if (this.compute == 4) {
                this.currentBasicBlock.frame.execute(n2, 0, null, null);
                label.getCanonicalInstance().flags = (short)(label.getCanonicalInstance().flags | 2);
                this.addSuccessorToCurrentBasicBlock(0, label);
                if (n2 != 167) {
                    label2 = new Label();
                }
            } else if (this.compute == 3) {
                this.currentBasicBlock.frame.execute(n2, 0, null, null);
            } else if (this.compute == 2) {
                this.relativeStackSize += STACK_SIZE_DELTA[n2];
            } else if (n2 == 168) {
                if ((label.flags & 0x20) == 0) {
                    label.flags = (short)(label.flags | 0x20);
                    this.hasSubroutines = true;
                }
                this.currentBasicBlock.flags = (short)(this.currentBasicBlock.flags | 0x10);
                this.addSuccessorToCurrentBasicBlock(this.relativeStackSize + 1, label);
                label2 = new Label();
            } else {
                this.relativeStackSize += STACK_SIZE_DELTA[n2];
                this.addSuccessorToCurrentBasicBlock(this.relativeStackSize, label);
            }
            if (label2 != null) {
                if (bl) {
                    label2.flags = (short)(label2.flags | 2);
                }
                this.visitLabel(label2);
            }
            if (n2 == 167) {
                this.endCurrentBasicBlockWithNoSuccessor();
            }
        }
    }

    public void visitLabel(Label label) {
        this.hasAsmInstructions |= label.resolve(this.code.data, this.code.length);
        if ((label.flags & 1) != 0) {
            return;
        }
        if (this.compute == 4) {
            if (this.currentBasicBlock != null) {
                if (label.bytecodeOffset == this.currentBasicBlock.bytecodeOffset) {
                    this.currentBasicBlock.flags = (short)(this.currentBasicBlock.flags | label.flags & 2);
                    label.frame = this.currentBasicBlock.frame;
                    return;
                }
                this.addSuccessorToCurrentBasicBlock(0, label);
            }
            if (this.lastBasicBlock != null) {
                if (label.bytecodeOffset == this.lastBasicBlock.bytecodeOffset) {
                    this.lastBasicBlock.flags = (short)(this.lastBasicBlock.flags | label.flags & 2);
                    label.frame = this.lastBasicBlock.frame;
                    this.currentBasicBlock = this.lastBasicBlock;
                    return;
                }
                this.lastBasicBlock.nextBasicBlock = label;
            }
            this.lastBasicBlock = label;
            this.currentBasicBlock = label;
            label.frame = new Frame(label);
        } else if (this.compute == 3) {
            if (this.currentBasicBlock == null) {
                this.currentBasicBlock = label;
            } else {
                this.currentBasicBlock.frame.owner = label;
            }
        } else if (this.compute == 1) {
            if (this.currentBasicBlock != null) {
                this.currentBasicBlock.outputStackMax = (short)this.maxRelativeStackSize;
                this.addSuccessorToCurrentBasicBlock(this.relativeStackSize, label);
            }
            this.currentBasicBlock = label;
            this.relativeStackSize = 0;
            this.maxRelativeStackSize = 0;
            if (this.lastBasicBlock != null) {
                this.lastBasicBlock.nextBasicBlock = label;
            }
            this.lastBasicBlock = label;
        } else if (this.compute == 2 && this.currentBasicBlock == null) {
            this.currentBasicBlock = label;
        }
    }

    public void visitLdcInsn(Object object) {
        char c;
        boolean bl;
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstant(object);
        int n = symbol.index;
        boolean bl2 = bl = symbol.tag == 5 || symbol.tag == 6 || symbol.tag == 17 && ((c = symbol.value.charAt(0)) == 'J' || c == 'D');
        if (bl) {
            this.code.put12(20, n);
        } else if (n >= 256) {
            this.code.put12(19, n);
        } else {
            this.code.put11(18, n);
        }
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(18, 0, symbol, this.symbolTable);
            } else {
                int n2 = this.relativeStackSize + (bl ? 2 : 1);
                if (n2 > this.maxRelativeStackSize) {
                    this.maxRelativeStackSize = n2;
                }
                this.relativeStackSize = n2;
            }
        }
    }

    public void visitIincInsn(int n, int n2) {
        int n3;
        this.lastBytecodeOffset = this.code.length;
        if (n > 255 || n2 > 127 || n2 < -128) {
            this.code.putByte(196).put12(132, n).putShort(n2);
        } else {
            this.code.putByte(132).put11(n, n2);
        }
        if (this.currentBasicBlock != null && (this.compute == 4 || this.compute == 3)) {
            this.currentBasicBlock.frame.execute(132, n, null, null);
        }
        if (this.compute != 0 && (n3 = n + 1) > this.maxLocals) {
            this.maxLocals = n3;
        }
    }

    public void visitTableSwitchInsn(int n, int n2, Label label, Label ... labelArray) {
        this.lastBytecodeOffset = this.code.length;
        this.code.putByte(170).putByteArray(null, 0, (4 - this.code.length % 4) % 4);
        label.put(this.code, this.lastBytecodeOffset, true);
        this.code.putInt(n).putInt(n2);
        for (Label label2 : labelArray) {
            label2.put(this.code, this.lastBytecodeOffset, true);
        }
        this.visitSwitchInsn(label, labelArray);
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        this.lastBytecodeOffset = this.code.length;
        this.code.putByte(171).putByteArray(null, 0, (4 - this.code.length % 4) % 4);
        label.put(this.code, this.lastBytecodeOffset, true);
        this.code.putInt(labelArray.length);
        for (int i = 0; i < labelArray.length; ++i) {
            this.code.putInt(nArray[i]);
            labelArray[i].put(this.code, this.lastBytecodeOffset, true);
        }
        this.visitSwitchInsn(label, labelArray);
    }

    private void visitSwitchInsn(Label label, Label[] labelArray) {
        if (this.currentBasicBlock != null) {
            if (this.compute == 4) {
                this.currentBasicBlock.frame.execute(171, 0, null, null);
                this.addSuccessorToCurrentBasicBlock(0, label);
                label.getCanonicalInstance().flags = (short)(label.getCanonicalInstance().flags | 2);
                for (Label label2 : labelArray) {
                    this.addSuccessorToCurrentBasicBlock(0, label2);
                    label2.getCanonicalInstance().flags = (short)(label2.getCanonicalInstance().flags | 2);
                }
            } else if (this.compute == 1) {
                --this.relativeStackSize;
                this.addSuccessorToCurrentBasicBlock(this.relativeStackSize, label);
                for (Label label3 : labelArray) {
                    this.addSuccessorToCurrentBasicBlock(this.relativeStackSize, label3);
                }
            }
            this.endCurrentBasicBlockWithNoSuccessor();
        }
    }

    public void visitMultiANewArrayInsn(String string, int n) {
        this.lastBytecodeOffset = this.code.length;
        Symbol symbol = this.symbolTable.addConstantClass(string);
        this.code.put12(197, symbol.index).putByte(n);
        if (this.currentBasicBlock != null) {
            if (this.compute == 4 || this.compute == 3) {
                this.currentBasicBlock.frame.execute(197, n, symbol, this.symbolTable);
            } else {
                this.relativeStackSize += 1 - n;
            }
        }
    }

    public AnnotationVisitor visitInsnAnnotation(int n, TypePath typePath, String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        TypeReference.putTarget(n & 0xFF0000FF | this.lastBytecodeOffset << 8, byteVector);
        TypePath.put(typePath, byteVector);
        byteVector.putShort(this.symbolTable.addConstantUtf8(string)).putShort(0);
        if (bl) {
            this.lastCodeRuntimeVisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastCodeRuntimeVisibleTypeAnnotation);
            return this.lastCodeRuntimeVisibleTypeAnnotation;
        }
        this.lastCodeRuntimeInvisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastCodeRuntimeInvisibleTypeAnnotation);
        return this.lastCodeRuntimeInvisibleTypeAnnotation;
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        Handler handler = new Handler(label, label2, label3, string != null ? this.symbolTable.addConstantClass((String)string).index : 0, string);
        if (this.firstHandler == null) {
            this.firstHandler = handler;
        } else {
            this.lastHandler.nextHandler = handler;
        }
        this.lastHandler = handler;
    }

    public AnnotationVisitor visitTryCatchAnnotation(int n, TypePath typePath, String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        TypeReference.putTarget(n, byteVector);
        TypePath.put(typePath, byteVector);
        byteVector.putShort(this.symbolTable.addConstantUtf8(string)).putShort(0);
        if (bl) {
            this.lastCodeRuntimeVisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastCodeRuntimeVisibleTypeAnnotation);
            return this.lastCodeRuntimeVisibleTypeAnnotation;
        }
        this.lastCodeRuntimeInvisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastCodeRuntimeInvisibleTypeAnnotation);
        return this.lastCodeRuntimeInvisibleTypeAnnotation;
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        char c;
        int n2;
        if (string3 != null) {
            if (this.localVariableTypeTable == null) {
                this.localVariableTypeTable = new ByteVector();
            }
            ++this.localVariableTypeTableLength;
            this.localVariableTypeTable.putShort(label.bytecodeOffset).putShort(label2.bytecodeOffset - label.bytecodeOffset).putShort(this.symbolTable.addConstantUtf8(string)).putShort(this.symbolTable.addConstantUtf8(string3)).putShort(n);
        }
        if (this.localVariableTable == null) {
            this.localVariableTable = new ByteVector();
        }
        ++this.localVariableTableLength;
        this.localVariableTable.putShort(label.bytecodeOffset).putShort(label2.bytecodeOffset - label.bytecodeOffset).putShort(this.symbolTable.addConstantUtf8(string)).putShort(this.symbolTable.addConstantUtf8(string2)).putShort(n);
        if (this.compute != 0 && (n2 = n + ((c = string2.charAt(0)) == 'J' || c == 'D' ? 2 : 1)) > this.maxLocals) {
            this.maxLocals = n2;
        }
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        byteVector.putByte(n >>> 24).putShort(labelArray.length);
        for (int i = 0; i < labelArray.length; ++i) {
            byteVector.putShort(labelArray[i].bytecodeOffset).putShort(labelArray2[i].bytecodeOffset - labelArray[i].bytecodeOffset).putShort(nArray[i]);
        }
        TypePath.put(typePath, byteVector);
        byteVector.putShort(this.symbolTable.addConstantUtf8(string)).putShort(0);
        if (bl) {
            this.lastCodeRuntimeVisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastCodeRuntimeVisibleTypeAnnotation);
            return this.lastCodeRuntimeVisibleTypeAnnotation;
        }
        this.lastCodeRuntimeInvisibleTypeAnnotation = new AnnotationWriter(this.symbolTable, byteVector, this.lastCodeRuntimeInvisibleTypeAnnotation);
        return this.lastCodeRuntimeInvisibleTypeAnnotation;
    }

    public void visitLineNumber(int n, Label label) {
        if (this.lineNumberTable == null) {
            this.lineNumberTable = new ByteVector();
        }
        ++this.lineNumberTableLength;
        this.lineNumberTable.putShort(label.bytecodeOffset);
        this.lineNumberTable.putShort(n);
    }

    public void visitMaxs(int n, int n2) {
        if (this.compute == 4) {
            this.computeAllFrames();
        } else if (this.compute == 1) {
            this.computeMaxStackAndLocal();
        } else if (this.compute == 2) {
            this.maxStack = this.maxRelativeStackSize;
        } else {
            this.maxStack = n;
            this.maxLocals = n2;
        }
    }

    private void computeAllFrames() {
        int n;
        Label label;
        Object object;
        Handler handler = this.firstHandler;
        while (handler != null) {
            object = handler.catchTypeDescriptor == null ? "java/lang/Throwable" : handler.catchTypeDescriptor;
            int n2 = Frame.getAbstractTypeFromInternalName(this.symbolTable, (String)object);
            Label label2 = handler.handlerPc.getCanonicalInstance();
            label2.flags = (short)(label2.flags | 2);
            label = handler.startPc.getCanonicalInstance();
            Label label3 = handler.endPc.getCanonicalInstance();
            while (label != label3) {
                label.outgoingEdges = new Edge(n2, label2, label.outgoingEdges);
                label = label.nextBasicBlock;
            }
            handler = handler.nextHandler;
        }
        object = this.firstBasicBlock.frame;
        ((Frame)object).setInputFrameFromDescriptor(this.symbolTable, this.accessFlags, this.descriptor, this.maxLocals);
        ((Frame)object).accept(this);
        Label label4 = this.firstBasicBlock;
        label4.nextListElement = Label.EMPTY_LIST;
        int n3 = 0;
        while (label4 != Label.EMPTY_LIST) {
            label = label4;
            label4 = label4.nextListElement;
            label.nextListElement = null;
            label.flags = (short)(label.flags | 8);
            int n4 = label.frame.getInputStackSize() + label.outputStackMax;
            if (n4 > n3) {
                n3 = n4;
            }
            Edge edge = label.outgoingEdges;
            while (edge != null) {
                Label label5 = edge.successor.getCanonicalInstance();
                n = label.frame.merge(this.symbolTable, label5.frame, edge.info) ? 1 : 0;
                if (n != 0 && label5.nextListElement == null) {
                    label5.nextListElement = label4;
                    label4 = label5;
                }
                edge = edge.nextEdge;
            }
        }
        label = this.firstBasicBlock;
        while (label != null) {
            int n5;
            Label label6;
            int n6;
            if ((label.flags & 0xA) == 10) {
                label.frame.accept(this);
            }
            if ((label.flags & 8) == 0 && (n6 = ((label6 = label.nextBasicBlock) == null ? this.code.length : label6.bytecodeOffset) - 1) >= (n5 = label.bytecodeOffset)) {
                for (n = n5; n < n6; ++n) {
                    this.code.data[n] = 0;
                }
                this.code.data[n6] = -65;
                n = this.visitFrameStart(n5, 0, 1);
                this.currentFrame[n] = Frame.getAbstractTypeFromInternalName(this.symbolTable, "java/lang/Throwable");
                this.visitFrameEnd();
                this.firstHandler = Handler.removeRange(this.firstHandler, label, label6);
                n3 = Math.max(n3, 1);
            }
            label = label.nextBasicBlock;
        }
        this.maxStack = n3;
    }

    private void computeMaxStackAndLocal() {
        Label label;
        Label label2;
        Handler handler = this.firstHandler;
        while (handler != null) {
            Label label3 = handler.handlerPc;
            label2 = handler.startPc;
            label = handler.endPc;
            while (label2 != label) {
                if ((label2.flags & 0x10) == 0) {
                    label2.outgoingEdges = new Edge(Integer.MAX_VALUE, label3, label2.outgoingEdges);
                } else {
                    label2.outgoingEdges.nextEdge.nextEdge = new Edge(Integer.MAX_VALUE, label3, label2.outgoingEdges.nextEdge.nextEdge);
                }
                label2 = label2.nextBasicBlock;
            }
            handler = handler.nextHandler;
        }
        if (this.hasSubroutines) {
            short s = 1;
            this.firstBasicBlock.markSubroutine(s);
            for (short s2 = 1; s2 <= s; s2 = (short)(s2 + 1)) {
                label = this.firstBasicBlock;
                while (label != null) {
                    if ((label.flags & 0x10) != 0 && label.subroutineId == s2) {
                        Label label4 = label.outgoingEdges.nextEdge.successor;
                        if (label4.subroutineId == 0) {
                            s = (short)(s + 1);
                            label4.markSubroutine(s);
                        }
                    }
                    label = label.nextBasicBlock;
                }
            }
            label2 = this.firstBasicBlock;
            while (label2 != null) {
                if ((label2.flags & 0x10) != 0) {
                    label = label2.outgoingEdges.nextEdge.successor;
                    label.addSubroutineRetSuccessors(label2);
                }
                label2 = label2.nextBasicBlock;
            }
        }
        Label label5 = this.firstBasicBlock;
        label5.nextListElement = Label.EMPTY_LIST;
        int n = this.maxStack;
        while (label5 != Label.EMPTY_LIST) {
            label = label5;
            label5 = label5.nextListElement;
            short s = label.inputStackSize;
            int n2 = s + label.outputStackMax;
            if (n2 > n) {
                n = n2;
            }
            Edge edge = label.outgoingEdges;
            if ((label.flags & 0x10) != 0) {
                edge = edge.nextEdge;
            }
            while (edge != null) {
                Label label6 = edge.successor;
                if (label6.nextListElement == null) {
                    label6.inputStackSize = (short)(edge.info == Integer.MAX_VALUE ? 1 : s + edge.info);
                    label6.nextListElement = label5;
                    label5 = label6;
                }
                edge = edge.nextEdge;
            }
        }
        this.maxStack = n;
    }

    public void visitEnd() {
    }

    private void addSuccessorToCurrentBasicBlock(int n, Label label) {
        this.currentBasicBlock.outgoingEdges = new Edge(n, label, this.currentBasicBlock.outgoingEdges);
    }

    private void endCurrentBasicBlockWithNoSuccessor() {
        if (this.compute == 4) {
            Label label = new Label();
            label.frame = new Frame(label);
            label.resolve(this.code.data, this.code.length);
            this.lastBasicBlock.nextBasicBlock = label;
            this.lastBasicBlock = label;
            this.currentBasicBlock = null;
        } else if (this.compute == 1) {
            this.currentBasicBlock.outputStackMax = (short)this.maxRelativeStackSize;
            this.currentBasicBlock = null;
        }
    }

    int visitFrameStart(int n, int n2, int n3) {
        int n4 = 3 + n2 + n3;
        if (this.currentFrame == null || this.currentFrame.length < n4) {
            this.currentFrame = new int[n4];
        }
        this.currentFrame[0] = n;
        this.currentFrame[1] = n2;
        this.currentFrame[2] = n3;
        return 3;
    }

    void visitAbstractType(int n, int n2) {
        this.currentFrame[n] = n2;
    }

    void visitFrameEnd() {
        if (this.previousFrame != null) {
            if (this.stackMapTableEntries == null) {
                this.stackMapTableEntries = new ByteVector();
            }
            this.putFrame();
            ++this.stackMapTableNumberOfEntries;
        }
        this.previousFrame = this.currentFrame;
        this.currentFrame = null;
    }

    private void putFrame() {
        int n = this.currentFrame[1];
        int n2 = this.currentFrame[2];
        if (this.symbolTable.getMajorVersion() < 50) {
            this.stackMapTableEntries.putShort(this.currentFrame[0]).putShort(n);
            this.putAbstractTypes(3, 3 + n);
            this.stackMapTableEntries.putShort(n2);
            this.putAbstractTypes(3 + n, 3 + n + n2);
            return;
        }
        int n3 = this.stackMapTableNumberOfEntries == 0 ? this.currentFrame[0] : this.currentFrame[0] - this.previousFrame[0] - 1;
        int n4 = this.previousFrame[1];
        int n5 = n - n4;
        int n6 = 255;
        if (n2 == 0) {
            switch (n5) {
                case -3: 
                case -2: 
                case -1: {
                    n6 = 248;
                    break;
                }
                case 0: {
                    n6 = n3 < 64 ? 0 : 251;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n6 = 252;
                    break;
                }
            }
        } else if (n5 == 0 && n2 == 1) {
            int n7 = n6 = n3 < 63 ? 64 : 247;
        }
        if (n6 != 255) {
            int n8 = 3;
            for (int i = 0; i < n4 && i < n; ++i) {
                if (this.currentFrame[n8] != this.previousFrame[n8]) {
                    n6 = 255;
                    break;
                }
                ++n8;
            }
        }
        switch (n6) {
            case 0: {
                this.stackMapTableEntries.putByte(n3);
                break;
            }
            case 64: {
                this.stackMapTableEntries.putByte(64 + n3);
                this.putAbstractTypes(3 + n, 4 + n);
                break;
            }
            case 247: {
                this.stackMapTableEntries.putByte(247).putShort(n3);
                this.putAbstractTypes(3 + n, 4 + n);
                break;
            }
            case 251: {
                this.stackMapTableEntries.putByte(251).putShort(n3);
                break;
            }
            case 248: {
                this.stackMapTableEntries.putByte(251 + n5).putShort(n3);
                break;
            }
            case 252: {
                this.stackMapTableEntries.putByte(251 + n5).putShort(n3);
                this.putAbstractTypes(3 + n4, 3 + n);
                break;
            }
            default: {
                this.stackMapTableEntries.putByte(255).putShort(n3).putShort(n);
                this.putAbstractTypes(3, 3 + n);
                this.stackMapTableEntries.putShort(n2);
                this.putAbstractTypes(3 + n, 3 + n + n2);
            }
        }
    }

    private void putAbstractTypes(int n, int n2) {
        for (int i = n; i < n2; ++i) {
            Frame.putAbstractType(this.symbolTable, this.currentFrame[i], this.stackMapTableEntries);
        }
    }

    private void putFrameType(Object object) {
        if (object instanceof Integer) {
            this.stackMapTableEntries.putByte((Integer)object);
        } else if (object instanceof String) {
            this.stackMapTableEntries.putByte(7).putShort(this.symbolTable.addConstantClass((String)((String)object)).index);
        } else {
            this.stackMapTableEntries.putByte(8).putShort(((Label)object).bytecodeOffset);
        }
    }

    boolean canCopyMethodAttributes(ClassReader classReader, int n, int n2, boolean bl, boolean bl2, int n3, int n4, int n5) {
        boolean bl3;
        if (classReader != this.symbolTable.getSource() || n3 != this.descriptorIndex || n4 != this.signatureIndex || bl2 != ((this.accessFlags & 0x20000) != 0)) {
            return false;
        }
        boolean bl4 = bl3 = this.symbolTable.getMajorVersion() < 49 && (this.accessFlags & 0x1000) != 0;
        if (bl != bl3) {
            return false;
        }
        if (n5 == 0) {
            if (this.numberOfExceptions != 0) {
                return false;
            }
        } else if (classReader.readUnsignedShort(n5) == this.numberOfExceptions) {
            int n6 = n5 + 2;
            for (int i = 0; i < this.numberOfExceptions; ++i) {
                if (classReader.readUnsignedShort(n6) != this.exceptionIndexTable[i]) {
                    return false;
                }
                n6 += 2;
            }
        }
        this.sourceOffset = n + 6;
        this.sourceLength = n2 - 6;
        return true;
    }

    int computeMethodInfoSize() {
        boolean bl;
        if (this.sourceOffset != 0) {
            return 6 + this.sourceLength;
        }
        int n = 8;
        if (this.code.length > 0) {
            if (this.code.length > 65535) {
                throw new MethodTooLargeException(this.symbolTable.getClassName(), this.name, this.descriptor, this.code.length);
            }
            this.symbolTable.addConstantUtf8("Code");
            n += 16 + this.code.length + Handler.getExceptionTableSize(this.firstHandler);
            if (this.stackMapTableEntries != null) {
                bl = this.symbolTable.getMajorVersion() >= 50;
                this.symbolTable.addConstantUtf8(bl ? "StackMapTable" : "StackMap");
                n += 8 + this.stackMapTableEntries.length;
            }
            if (this.lineNumberTable != null) {
                this.symbolTable.addConstantUtf8("LineNumberTable");
                n += 8 + this.lineNumberTable.length;
            }
            if (this.localVariableTable != null) {
                this.symbolTable.addConstantUtf8("LocalVariableTable");
                n += 8 + this.localVariableTable.length;
            }
            if (this.localVariableTypeTable != null) {
                this.symbolTable.addConstantUtf8("LocalVariableTypeTable");
                n += 8 + this.localVariableTypeTable.length;
            }
            if (this.lastCodeRuntimeVisibleTypeAnnotation != null) {
                n += this.lastCodeRuntimeVisibleTypeAnnotation.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
            }
            if (this.lastCodeRuntimeInvisibleTypeAnnotation != null) {
                n += this.lastCodeRuntimeInvisibleTypeAnnotation.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
            }
            if (this.firstCodeAttribute != null) {
                n += this.firstCodeAttribute.computeAttributesSize(this.symbolTable, this.code.data, this.code.length, this.maxStack, this.maxLocals);
            }
        }
        if (this.numberOfExceptions > 0) {
            this.symbolTable.addConstantUtf8("Exceptions");
            n += 8 + 2 * this.numberOfExceptions;
        }
        boolean bl2 = bl = this.symbolTable.getMajorVersion() < 49;
        if ((this.accessFlags & 0x1000) != 0 && bl) {
            this.symbolTable.addConstantUtf8("Synthetic");
            n += 6;
        }
        if (this.signatureIndex != 0) {
            this.symbolTable.addConstantUtf8("Signature");
            n += 8;
        }
        if ((this.accessFlags & 0x20000) != 0) {
            this.symbolTable.addConstantUtf8("Deprecated");
            n += 6;
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            n += this.lastRuntimeVisibleAnnotation.computeAnnotationsSize("RuntimeVisibleAnnotations");
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            n += this.lastRuntimeInvisibleAnnotation.computeAnnotationsSize("RuntimeInvisibleAnnotations");
        }
        if (this.lastRuntimeVisibleParameterAnnotations != null) {
            n += AnnotationWriter.computeParameterAnnotationsSize("RuntimeVisibleParameterAnnotations", this.lastRuntimeVisibleParameterAnnotations, this.visibleAnnotableParameterCount == 0 ? this.lastRuntimeVisibleParameterAnnotations.length : this.visibleAnnotableParameterCount);
        }
        if (this.lastRuntimeInvisibleParameterAnnotations != null) {
            n += AnnotationWriter.computeParameterAnnotationsSize("RuntimeInvisibleParameterAnnotations", this.lastRuntimeInvisibleParameterAnnotations, this.invisibleAnnotableParameterCount == 0 ? this.lastRuntimeInvisibleParameterAnnotations.length : this.invisibleAnnotableParameterCount);
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            n += this.lastRuntimeVisibleTypeAnnotation.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            n += this.lastRuntimeInvisibleTypeAnnotation.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
        }
        if (this.defaultValue != null) {
            this.symbolTable.addConstantUtf8("AnnotationDefault");
            n += 6 + this.defaultValue.length;
        }
        if (this.parameters != null) {
            this.symbolTable.addConstantUtf8("MethodParameters");
            n += 7 + this.parameters.length;
        }
        if (this.firstAttribute != null) {
            n += this.firstAttribute.computeAttributesSize(this.symbolTable);
        }
        return n;
    }

    void putMethodInfo(ByteVector byteVector) {
        boolean bl = this.symbolTable.getMajorVersion() < 49;
        int n = bl ? 4096 : 0;
        byteVector.putShort(this.accessFlags & ~n).putShort(this.nameIndex).putShort(this.descriptorIndex);
        if (this.sourceOffset != 0) {
            byteVector.putByteArray(this.symbolTable.getSource().b, this.sourceOffset, this.sourceLength);
            return;
        }
        int n2 = 0;
        if (this.code.length > 0) {
            ++n2;
        }
        if (this.numberOfExceptions > 0) {
            ++n2;
        }
        if ((this.accessFlags & 0x1000) != 0 && bl) {
            ++n2;
        }
        if (this.signatureIndex != 0) {
            ++n2;
        }
        if ((this.accessFlags & 0x20000) != 0) {
            ++n2;
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeVisibleParameterAnnotations != null) {
            ++n2;
        }
        if (this.lastRuntimeInvisibleParameterAnnotations != null) {
            ++n2;
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            ++n2;
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            ++n2;
        }
        if (this.defaultValue != null) {
            ++n2;
        }
        if (this.parameters != null) {
            ++n2;
        }
        if (this.firstAttribute != null) {
            n2 += this.firstAttribute.getAttributeCount();
        }
        byteVector.putShort(n2);
        if (this.code.length > 0) {
            int n3 = 10 + this.code.length + Handler.getExceptionTableSize(this.firstHandler);
            int n4 = 0;
            if (this.stackMapTableEntries != null) {
                n3 += 8 + this.stackMapTableEntries.length;
                ++n4;
            }
            if (this.lineNumberTable != null) {
                n3 += 8 + this.lineNumberTable.length;
                ++n4;
            }
            if (this.localVariableTable != null) {
                n3 += 8 + this.localVariableTable.length;
                ++n4;
            }
            if (this.localVariableTypeTable != null) {
                n3 += 8 + this.localVariableTypeTable.length;
                ++n4;
            }
            if (this.lastCodeRuntimeVisibleTypeAnnotation != null) {
                n3 += this.lastCodeRuntimeVisibleTypeAnnotation.computeAnnotationsSize("RuntimeVisibleTypeAnnotations");
                ++n4;
            }
            if (this.lastCodeRuntimeInvisibleTypeAnnotation != null) {
                n3 += this.lastCodeRuntimeInvisibleTypeAnnotation.computeAnnotationsSize("RuntimeInvisibleTypeAnnotations");
                ++n4;
            }
            if (this.firstCodeAttribute != null) {
                n3 += this.firstCodeAttribute.computeAttributesSize(this.symbolTable, this.code.data, this.code.length, this.maxStack, this.maxLocals);
                n4 += this.firstCodeAttribute.getAttributeCount();
            }
            byteVector.putShort(this.symbolTable.addConstantUtf8("Code")).putInt(n3).putShort(this.maxStack).putShort(this.maxLocals).putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            Handler.putExceptionTable(this.firstHandler, byteVector);
            byteVector.putShort(n4);
            if (this.stackMapTableEntries != null) {
                int n5 = this.symbolTable.getMajorVersion() >= 50 ? 1 : 0;
                byteVector.putShort(this.symbolTable.addConstantUtf8(n5 != 0 ? "StackMapTable" : "StackMap")).putInt(2 + this.stackMapTableEntries.length).putShort(this.stackMapTableNumberOfEntries).putByteArray(this.stackMapTableEntries.data, 0, this.stackMapTableEntries.length);
            }
            if (this.lineNumberTable != null) {
                byteVector.putShort(this.symbolTable.addConstantUtf8("LineNumberTable")).putInt(2 + this.lineNumberTable.length).putShort(this.lineNumberTableLength).putByteArray(this.lineNumberTable.data, 0, this.lineNumberTable.length);
            }
            if (this.localVariableTable != null) {
                byteVector.putShort(this.symbolTable.addConstantUtf8("LocalVariableTable")).putInt(2 + this.localVariableTable.length).putShort(this.localVariableTableLength).putByteArray(this.localVariableTable.data, 0, this.localVariableTable.length);
            }
            if (this.localVariableTypeTable != null) {
                byteVector.putShort(this.symbolTable.addConstantUtf8("LocalVariableTypeTable")).putInt(2 + this.localVariableTypeTable.length).putShort(this.localVariableTypeTableLength).putByteArray(this.localVariableTypeTable.data, 0, this.localVariableTypeTable.length);
            }
            if (this.lastCodeRuntimeVisibleTypeAnnotation != null) {
                this.lastCodeRuntimeVisibleTypeAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeVisibleTypeAnnotations"), byteVector);
            }
            if (this.lastCodeRuntimeInvisibleTypeAnnotation != null) {
                this.lastCodeRuntimeInvisibleTypeAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeInvisibleTypeAnnotations"), byteVector);
            }
            if (this.firstCodeAttribute != null) {
                this.firstCodeAttribute.putAttributes(this.symbolTable, this.code.data, this.code.length, this.maxStack, this.maxLocals, byteVector);
            }
        }
        if (this.numberOfExceptions > 0) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("Exceptions")).putInt(2 + 2 * this.numberOfExceptions).putShort(this.numberOfExceptions);
            for (int n6 : this.exceptionIndexTable) {
                byteVector.putShort(n6);
            }
        }
        if ((this.accessFlags & 0x1000) != 0 && bl) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("Synthetic")).putInt(0);
        }
        if (this.signatureIndex != 0) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("Signature")).putInt(2).putShort(this.signatureIndex);
        }
        if ((this.accessFlags & 0x20000) != 0) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("Deprecated")).putInt(0);
        }
        if (this.lastRuntimeVisibleAnnotation != null) {
            this.lastRuntimeVisibleAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeVisibleAnnotations"), byteVector);
        }
        if (this.lastRuntimeInvisibleAnnotation != null) {
            this.lastRuntimeInvisibleAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeInvisibleAnnotations"), byteVector);
        }
        if (this.lastRuntimeVisibleParameterAnnotations != null) {
            AnnotationWriter.putParameterAnnotations(this.symbolTable.addConstantUtf8("RuntimeVisibleParameterAnnotations"), this.lastRuntimeVisibleParameterAnnotations, this.visibleAnnotableParameterCount == 0 ? this.lastRuntimeVisibleParameterAnnotations.length : this.visibleAnnotableParameterCount, byteVector);
        }
        if (this.lastRuntimeInvisibleParameterAnnotations != null) {
            AnnotationWriter.putParameterAnnotations(this.symbolTable.addConstantUtf8("RuntimeInvisibleParameterAnnotations"), this.lastRuntimeInvisibleParameterAnnotations, this.invisibleAnnotableParameterCount == 0 ? this.lastRuntimeInvisibleParameterAnnotations.length : this.invisibleAnnotableParameterCount, byteVector);
        }
        if (this.lastRuntimeVisibleTypeAnnotation != null) {
            this.lastRuntimeVisibleTypeAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeVisibleTypeAnnotations"), byteVector);
        }
        if (this.lastRuntimeInvisibleTypeAnnotation != null) {
            this.lastRuntimeInvisibleTypeAnnotation.putAnnotations(this.symbolTable.addConstantUtf8("RuntimeInvisibleTypeAnnotations"), byteVector);
        }
        if (this.defaultValue != null) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("AnnotationDefault")).putInt(this.defaultValue.length).putByteArray(this.defaultValue.data, 0, this.defaultValue.length);
        }
        if (this.parameters != null) {
            byteVector.putShort(this.symbolTable.addConstantUtf8("MethodParameters")).putInt(1 + this.parameters.length).putByte(this.parametersCount).putByteArray(this.parameters.data, 0, this.parameters.length);
        }
        if (this.firstAttribute != null) {
            this.firstAttribute.putAttributes(this.symbolTable, byteVector);
        }
    }

    final void collectAttributePrototypes(Attribute.Set set) {
        set.addAttributes(this.firstAttribute);
        set.addAttributes(this.firstCodeAttribute);
    }
}

