/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.commons;

import com.eg.org.objectweb.asm.Attribute;
import com.eg.org.objectweb.asm.ByteVector;
import com.eg.org.objectweb.asm.ClassReader;
import com.eg.org.objectweb.asm.ClassWriter;
import com.eg.org.objectweb.asm.Label;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleHashesAttribute
extends Attribute {
    public String algorithm;
    public List<String> modules;
    public List<byte[]> hashes;

    public ModuleHashesAttribute(String string, List<String> list, List<byte[]> list2) {
        super("ModuleHashes");
        this.algorithm = string;
        this.modules = list;
        this.hashes = list2;
    }

    public ModuleHashesAttribute() {
        this(null, null, null);
    }

    @Override
    protected Attribute read(ClassReader classReader, int n, int n2, char[] cArray, int n3, Label[] labelArray) {
        int n4 = n;
        String string = classReader.readUTF8(n4, cArray);
        int n5 = classReader.readUnsignedShort(n4 += 2);
        n4 += 2;
        ArrayList<String> arrayList = new ArrayList<String>(n5);
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>(n5);
        for (int i = 0; i < n5; ++i) {
            String string2 = classReader.readModule(n4, cArray);
            arrayList.add(string2);
            int n6 = classReader.readUnsignedShort(n4 += 2);
            n4 += 2;
            byte[] byArray = new byte[n6];
            for (int j = 0; j < n6; ++j) {
                byArray[j] = (byte)(classReader.readByte(n4) & 0xFF);
                ++n4;
            }
            arrayList2.add(byArray);
        }
        return new ModuleHashesAttribute(string, arrayList, arrayList2);
    }

    @Override
    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n, int n2, int n3) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(classWriter.newUTF8(this.algorithm));
        if (this.modules == null) {
            byteVector.putShort(0);
        } else {
            int n4 = this.modules.size();
            byteVector.putShort(n4);
            for (int i = 0; i < n4; ++i) {
                String string = this.modules.get(i);
                byte[] byArray2 = this.hashes.get(i);
                byteVector.putShort(classWriter.newModule(string)).putShort(byArray2.length).putByteArray(byArray2, 0, byArray2.length);
            }
        }
        return byteVector;
    }
}

