/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.egurkha.util.EgUtilities;
import java.util.ArrayList;
import java.util.Vector;

public class EgPerfInstrumentation {
    private static boolean isDebugEnabled;
    private long l_qh = -1L;
    private boolean isQueryValid = false;
    private boolean isCounterHandlesValid = false;
    private long[] counterPathHandles = null;
    private String[] monCounters = null;
    public static boolean is009HasEnglish;

    public static native long getQueryHandle();

    public static native long[] getCounterHandle(long var0, String[] var2, boolean var3);

    public static native double[] getValuesForCounters(long var0, long[] var2);

    public static native String[] getLocalizedCounterPath(String var0, String[] var1);

    public static native String[] getLocalizedCounterPath(String var0, String[] var1, String[] var2);

    public static native boolean Is009HasEnglishStrings();

    public static native void closeQueryHandle(long var0);

    public static native void closeCounterHandle(long[] var0);

    public static native long[] getNetStats(int var0);

    public static native String[] getTCPRows();

    public EgPerfInstrumentation() {
        this.init();
    }

    private boolean diffInstances(String[] stringArray, String[] stringArray2) {
        int n;
        boolean bl;
        int n2;
        if (stringArray == null && stringArray2 == null) {
            return false;
        }
        if (stringArray == null && stringArray2 != null) {
            return true;
        }
        if (stringArray2 == null && stringArray != null) {
            return true;
        }
        if (stringArray.length != stringArray2.length) {
            return true;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            bl = false;
            for (n = 0; n < stringArray2.length; ++n) {
                if (!stringArray2[n].equals(stringArray[n2])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return true;
        }
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equals(stringArray2[n2])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    public void stop() {
        if (this.counterPathHandles != null && this.counterPathHandles.length > 0 && this.isCounterHandlesValid) {
            int n = 0;
            for (int i = 0; i < this.counterPathHandles.length; ++i) {
                if (this.counterPathHandles[i] == -1L) continue;
                ++n;
            }
            long[] lArray = new long[n];
            int n2 = 0;
            for (int i = 0; i < this.counterPathHandles.length; ++i) {
                if (this.counterPathHandles[i] == -1L) continue;
                lArray[n2] = this.counterPathHandles[i];
                ++n2;
            }
            if (lArray.length > 0) {
                EgPerfInstrumentation.closeCounterHandle(lArray);
            }
        }
        this.counterPathHandles = null;
        this.isCounterHandlesValid = false;
        if (this.l_qh >= 0L && this.isQueryValid) {
            EgPerfInstrumentation.closeQueryHandle(this.l_qh);
        }
        this.l_qh = -1L;
        this.isQueryValid = false;
    }

    private void init() {
        this.l_qh = EgPerfInstrumentation.getQueryHandle();
        if (this.l_qh < 0L) {
            this.isQueryValid = false;
            this.l_qh = -1L;
        } else {
            this.isQueryValid = true;
        }
        is009HasEnglish = EgPerfInstrumentation.Is009HasEnglishStrings();
        if (isDebugEnabled) {
            System.out.println("[EgPerfInstrumentation] is009HasEnglish:" + is009HasEnglish);
        }
    }

    public double[] getCounterValue(String string, String[] stringArray) {
        double[] dArray = null;
        String[] stringArray2 = new String[stringArray.length];
        if (!this.isQueryValid) {
            this.init();
            if (!this.isQueryValid) {
                return null;
            }
        }
        if (is009HasEnglish) {
            String string2 = "\\" + string;
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray2[i] = string2 + "\\" + stringArray[i];
            }
        } else {
            stringArray2 = EgPerfInstrumentation.getLocalizedCounterPath(string, stringArray);
        }
        if (stringArray2 == null) {
            System.out.println("s_a_counterPath is null from JNI");
            return null;
        }
        if (isDebugEnabled) {
            System.out.println("[EgPerfInstrumentation] IsCounterHandlesValid:" + this.isCounterHandlesValid);
        }
        if (!this.isCounterHandlesValid) {
            this.counterPathHandles = is009HasEnglish ? EgPerfInstrumentation.getCounterHandle(this.l_qh, stringArray2, true) : EgPerfInstrumentation.getCounterHandle(this.l_qh, stringArray2, false);
            if (this.counterPathHandles == null) {
                this.stop();
                return null;
            }
            if (isDebugEnabled) {
                for (int i = 0; i < this.counterPathHandles.length; ++i) {
                    System.out.println("[EgPerfInstrumentation] Counter Handles are:" + this.counterPathHandles[i]);
                }
            }
            this.isCounterHandlesValid = true;
        }
        if (this.isCounterHandlesValid) {
            dArray = EgPerfInstrumentation.getValuesForCounters(this.l_qh, this.counterPathHandles);
        }
        if (dArray == null || dArray.length == 0) {
            this.stop();
            return null;
        }
        return dArray;
    }

    public static String[] discoverInstances(String string) {
        int n;
        int n2;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        String string2 = EgInstallInfo.getInstallDir() + "/lib/EnumPdhInstances.exe " + "\"" + string + "\"";
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines(string2);
        if (arrayList == null || arrayList.size() < 2) {
            if (isDebugEnabled) {
                System.out.println("[EgPerfInstrumentation] instancesList is NULL or size is ZERO so return!");
            }
            return stringArray;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 != null) {
            n2 = arrayList2.size();
            if (n2 <= 0) {
                return null;
            }
            for (n = 0; n < n2; ++n) {
                String string3 = (String)arrayList2.get(n);
                if (string3 == null || (string3 = string3.trim()).startsWith("eG_Error:")) continue;
                int n3 = 0;
                String string4 = string3 + "#";
                for (int i = 0; i < vector.size(); ++i) {
                    String string5 = (String)vector.get(i);
                    if (!string5.equalsIgnoreCase(string3) && !string5.startsWith(string4)) continue;
                    ++n3;
                }
                if (n3 > 0) {
                    string3 = string3 + "#" + n3;
                }
                vector.addElement(string3);
            }
        }
        if ((n2 = vector.size()) <= 0) {
            return null;
        }
        stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = (String)vector.get(n);
            if (!isDebugEnabled) continue;
            System.out.println("[EgPerfInstrumentation] instances[" + n + "]:" + stringArray[n]);
        }
        return stringArray;
    }

    public double[][] getCounterValue(String string, String[] stringArray, String[] stringArray2) {
        int n;
        Object object;
        double[] dArray = null;
        String[] stringArray3 = new String[stringArray.length * stringArray2.length];
        int n2 = 0;
        if (is009HasEnglish) {
            object = "\\" + string;
            for (n = 0; n < stringArray.length; ++n) {
                String string2 = "(" + stringArray[n] + ")\\";
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray3[n2] = (String)object + string2 + stringArray2[i];
                    if (isDebugEnabled) {
                        System.out.println("[EgPerfInstrumentation] s_a_counterPath[" + n2 + "]:" + stringArray3[n2]);
                    }
                    ++n2;
                }
            }
        } else {
            stringArray3 = EgPerfInstrumentation.getLocalizedCounterPath(string, stringArray2, stringArray);
        }
        if (stringArray3 == null) {
            System.out.println("s_a_counterPath is null from JNI");
            return null;
        }
        if (this.diffInstances(stringArray3, this.monCounters)) {
            this.stop();
        }
        this.monCounters = stringArray3;
        if (isDebugEnabled) {
            System.out.println("[EgPerfInstrumentation] after diffInstances for [" + string + "]:");
            System.out.println("[EgPerfInstrumentation] monCounters:" + this.monCounters + " isQueryValid " + this.isQueryValid);
        }
        if (!this.isQueryValid) {
            this.init();
            if (isDebugEnabled) {
                System.out.println("[EgPerfInstrumentation] isQueryValid : " + this.isQueryValid);
            }
            if (!this.isQueryValid) {
                return null;
            }
        }
        if (isDebugEnabled) {
            System.out.println("[EgPerfInstrumentation] isCounterHandlesValid : " + this.isCounterHandlesValid);
        }
        if (!this.isCounterHandlesValid) {
            this.counterPathHandles = is009HasEnglish ? EgPerfInstrumentation.getCounterHandle(this.l_qh, stringArray3, true) : EgPerfInstrumentation.getCounterHandle(this.l_qh, stringArray3, false);
            if (this.counterPathHandles == null) {
                if (isDebugEnabled) {
                    System.out.println("[EgPerfInstrumentation] counterPathHandles is NULL");
                }
                this.stop();
                return null;
            }
            this.isCounterHandlesValid = true;
        }
        if (isDebugEnabled) {
            System.out.println("[EgPerfInstrumentation] isCounterHandlesValid is :" + this.isCounterHandlesValid);
        }
        if (this.isCounterHandlesValid) {
            dArray = EgPerfInstrumentation.getValuesForCounters(this.l_qh, this.counterPathHandles);
        }
        if (dArray == null || dArray.length == 0) {
            if (isDebugEnabled) {
                System.out.println("[EgPerfInstrumentation] l_a_counterValue is NULL");
            }
            this.stop();
            return null;
        }
        object = new double[stringArray.length][stringArray2.length];
        n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            for (int i = 0; i < stringArray2.length; ++i) {
                object[n][i] = dArray[n2];
                ++n2;
            }
        }
        return object;
    }

    public static void main(String[] stringArray) {
        EgPerfInstrumentation egPerfInstrumentation = new EgPerfInstrumentation();
        try {
            String string = System.getenv("EGVMAGENT_INSTALL_DIR");
            if (string != null && string.trim().length() > 0) {
                EgInstallInfo.setInstallDir(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = stringArray.length;
        if (n < 2) {
            System.out.println("Usage:java EgPerfInstrumentation <IsInstanceBased> <Object> <Counter1> <Counter2> .....");
            System.out.println("Usage:Instacne Based: java EgPerfInstrumentation true \"Processor Information\" \"% Processor Time\" \"% User Time\"");
            System.out.println("Usage:Non-Instance Based: java EgPerfInstrumentation false \"System\" \"System Up Time\" \"Threads\"");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String[] stringArray2 = new String[n - 2];
        for (int i = 0; i < n; ++i) {
            if (i == 0 || i == 1) continue;
            stringArray2[i - 2] = stringArray[i];
        }
        if (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes")) {
            String[] stringArray3 = EgPerfInstrumentation.discoverInstances(string2);
            double[][] dArray = null;
            if (stringArray3 != null && stringArray3.length > 0) {
                dArray = egPerfInstrumentation.getCounterValue(string2, stringArray3, stringArray2);
                System.out.println("values" + dArray);
                if (dArray != null && dArray.length > 0) {
                    for (int i = 0; i < dArray.length; ++i) {
                        for (int j = 0; j < stringArray2.length; ++j) {
                            if (j == 0) {
                                System.out.println("Instance Name : " + stringArray3[i]);
                            }
                            System.out.println(stringArray2[j] + "=" + dArray[i][j]);
                        }
                    }
                } else {
                    System.out.println("Value is NULL or size is ZERO! " + dArray);
                }
            } else {
                System.out.println("Instance is NULL or size is ZERO! " + stringArray3);
            }
        } else {
            double[] dArray = egPerfInstrumentation.getCounterValue(string2, stringArray2);
            if (dArray != null && dArray.length > 0) {
                for (int i = 0; i < dArray.length; ++i) {
                    System.out.println(stringArray2[i] + "=" + dArray[i]);
                }
            } else {
                System.out.println("Value is NULL or size is ZERO! " + dArray);
            }
        }
    }

    static {
        System.loadLibrary("EgPerfInstrumentation");
        isDebugEnabled = false;
        is009HasEnglish = true;
    }
}

