/*
 * Decompiled with CFR 0.152.
 */
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.WinNT;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WmiQueryHandler {
    private int comThreading = 0;
    private boolean securityInitialized = false;
    private final Set<String> failedWmiClassNames = new HashSet<String>();
    private int wmiTimeout = 300000;

    public static <T extends Enum<T>> String getString(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        try {
            Object object = wmiResult.getValue(t, n);
            if (null == object) {
                return "";
            }
            return (String)object;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static <T extends Enum<T>> int getInt(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        try {
            Object object = wmiResult.getValue(t, n);
            if (null == object) {
                return 0;
            }
            return (Integer)object;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static <T extends Enum<T>> long getLong(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        try {
            Object object = wmiResult.getValue(t, n);
            if (null == object) {
                return 0L;
            }
            return (Long)object;
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static <T extends Enum<T>> boolean getBoolean(WbemcliUtil.WmiResult<T> wmiResult, T t, int n) {
        try {
            Object object = wmiResult.getValue(t, n);
            if (null == object) {
                return false;
            }
            return (Boolean)object;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static <T extends Enum<T>> String queryToString(WbemcliUtil.WmiQuery<T> wmiQuery) {
        Enum[] enumArray = (Enum[])wmiQuery.getPropertyEnum().getEnumConstants();
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        stringBuilder.append(enumArray[0].name());
        for (int i = 1; i < enumArray.length; ++i) {
            stringBuilder.append(',').append(enumArray[i].name());
        }
        stringBuilder.append(" FROM ").append(wmiQuery.getWmiClassName());
        return stringBuilder.toString();
    }

    protected void handleComException(WbemcliUtil.WmiQuery<?> wmiQuery, COMException cOMException) {
        System.out.println("[WmiQueryHandler] COM exception querying " + wmiQuery.getWmiClassName() + " ,which might not be on your system. Will not attempt to query it again. Error was:" + cOMException.getMessage());
    }

    public <T extends Enum<T>> WbemcliUtil.WmiResult<T> queryWMI(String string, WbemcliUtil.WmiQuery<T> wmiQuery) {
        wmiQuery.setNameSpace(string);
        WbemcliUtil wbemcliUtil = WbemcliUtil.INSTANCE;
        wbemcliUtil.getClass();
        WbemcliUtil.WmiResult wmiResult = new WbemcliUtil.WmiResult(wbemcliUtil, wmiQuery.getPropertyEnum());
        if (this.failedWmiClassNames.contains(wmiQuery.getWmiClassName())) {
            return wmiResult;
        }
        boolean bl = false;
        try {
            bl = this.initCOM();
            wmiResult = wmiQuery.execute(this.wmiTimeout);
        }
        catch (COMException cOMException) {
            this.failedWmiClassNames.add(wmiQuery.getWmiClassName());
            int n = cOMException.getHresult() == null ? -1 : cOMException.getHresult().intValue();
            switch (n) {
                case -2147217394: {
                    System.out.println("[WmiQueryHandler] COM exception: Invalid Namespace " + wmiQuery.getNameSpace());
                    break;
                }
                case -2147217392: {
                    System.out.println("[WmiQueryHandler] COM exception: Invalid Class " + wmiQuery.getWmiClassName());
                    break;
                }
                case -2147217385: {
                    System.out.println("[WmiQueryHandler] COM exception: Invalid Query: " + WmiQueryHandler.queryToString(wmiQuery));
                    break;
                }
                default: {
                    this.handleComException(wmiQuery, cOMException);
                    break;
                }
            }
        }
        catch (TimeoutException timeoutException) {
            System.out.println("[WmiQueryHandler] WMI query timed out after " + this.wmiTimeout + " ms " + WmiQueryHandler.queryToString(wmiQuery));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            this.unInitCOM();
        }
        return wmiResult;
    }

    public boolean initCOM() {
        boolean bl = false;
        bl = this.initCOM(this.getComThreading());
        if (!bl) {
            bl = this.initCOM(this.switchComThreading());
        }
        if (bl && !this.isSecurityInitialized()) {
            WinNT.HRESULT hRESULT = Ole32.INSTANCE.CoInitializeSecurity(null, -1, null, null, 0, 3, null, 0, null);
            if (COMUtils.FAILED((WinNT.HRESULT)hRESULT) && hRESULT.intValue() != -2147417831) {
                Ole32.INSTANCE.CoUninitialize();
                System.out.println((Object)new COMException("[WmiQueryHandler] Failed to initialize security.", hRESULT));
                return bl;
            }
            this.securityInitialized = true;
        }
        return bl;
    }

    protected boolean initCOM(int n) {
        WinNT.HRESULT hRESULT = Ole32.INSTANCE.CoInitializeEx(null, n);
        switch (hRESULT.intValue()) {
            case 0: 
            case 1: {
                return true;
            }
            case -2147417850: {
                return false;
            }
        }
        System.out.println((Object)new COMException("[WmiQueryHandler] Failed to initialize COM library.", hRESULT));
        return false;
    }

    public int getComThreading() {
        return this.comThreading;
    }

    public boolean isSecurityInitialized() {
        return this.securityInitialized;
    }

    public int switchComThreading() {
        this.comThreading = this.comThreading == 2 ? 0 : 2;
        return this.comThreading;
    }

    public void unInitCOM() {
        Ole32.INSTANCE.CoUninitialize();
    }

    public int getWmiTimeout() {
        return this.wmiTimeout;
    }

    public void setWmiTimeout(int n) {
        this.wmiTimeout = n;
    }
}

