/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.egurkha.util.EgUtilities;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Pdh;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.Vector;

public class CPdh {
    private String object;
    private String[] counters;
    private String[] instances;
    private Pdh pdh = null;
    public static final WinDef.LCID systemLCID = Kernel32.INSTANCE.GetSystemDefaultLCID();
    public static final WinDef.LCID userLCID = Kernel32.INSTANCE.GetUserDefaultLCID();
    public static final boolean isEnglishLocale = userLCID.intValue() == 1033 || userLCID.intValue() == 2057;
    private WinNT.HANDLEByReference pdhHandle = new WinNT.HANDLEByReference();
    private WinNT.HANDLE queryHandle = null;
    private int PDH_FMT_DOUBLE = 512;
    private int PDH_FMT_NOCAP100 = 32768;
    private boolean withInstance = false;
    private boolean isSleep = false;
    private ArrayList counterPaths = null;
    private ArrayList handlesList = null;
    private long sleepTime = 500L;

    public CPdh() {
        this.pdh = Pdh.INSTANCE;
    }

    public CPdh(String string, String[] stringArray) {
        this.object = string;
        this.counters = stringArray;
        this.pdh = Pdh.INSTANCE;
        this.withInstance = false;
    }

    public CPdh(String string, String[] stringArray, String[] stringArray2) {
        this.object = string;
        this.counters = stringArray2;
        this.instances = stringArray;
        this.pdh = Pdh.INSTANCE;
        this.withInstance = true;
    }

    public void setObject(String string) {
        this.object = string;
    }

    public void setCounters(String[] stringArray) {
        this.counters = stringArray;
    }

    public void removeInstances() {
        this.instances = null;
    }

    public void setSleepTime(long l) {
        this.sleepTime = l;
    }

    public void setSleep(boolean bl) {
        this.isSleep = bl;
    }

    public static String getSystemLocale() {
        WinDef.LCID lCID = Kernel32.INSTANCE.GetSystemDefaultLCID();
        int n = lCID.intValue();
        String string = Integer.toHexString(n);
        System.out.println("System Locale in hex format 0x" + string);
        return string;
    }

    public static String getUserLocale() {
        WinDef.LCID lCID = Kernel32.INSTANCE.GetUserDefaultLCID();
        int n = lCID.intValue();
        String string = Integer.toHexString(n);
        System.out.println("Current User Locale in hex format 0x" + string);
        return string;
    }

    public boolean diffInstances(String[] stringArray) {
        int n;
        boolean bl;
        int n2;
        if (stringArray == null && this.instances == null) {
            return false;
        }
        if (stringArray == null && this.instances != null) {
            return true;
        }
        if (this.instances == null && stringArray != null) {
            return true;
        }
        if (stringArray.length != this.instances.length) {
            return true;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            bl = false;
            for (n = 0; n < this.instances.length; ++n) {
                if (!this.instances[n].equals(stringArray[n2])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return true;
        }
        for (n2 = 0; n2 < this.instances.length; ++n2) {
            bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].equals(this.instances[n2])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    public boolean InitializePdh() {
        this.pdhHandle = new WinNT.HANDLEByReference();
        int n = this.pdh.PdhOpenQuery(null, null, this.pdhHandle);
        if (n == 0) {
            this.queryHandle = this.pdhHandle.getValue();
            return true;
        }
        return false;
    }

    public boolean isValidPdhQueryHandle() {
        return this.queryHandle != null;
    }

    public void getCounterPaths() {
        this.counterPaths = new ArrayList();
        for (int i = 0; i < this.counters.length; ++i) {
            String string = "\\" + this.object + "\\" + this.counters[i];
            this.counterPaths.add(string);
        }
    }

    public boolean getCounterPathWithInstances(String[] stringArray) {
        boolean bl = false;
        if (this.instances == null || this.diffInstances(stringArray)) {
            this.instances = stringArray;
            this.withInstance = true;
            this.closeCounterHandles();
            this.counterPaths = new ArrayList();
            if (this.withInstance) {
                for (int i = 0; i < this.instances.length; ++i) {
                    for (int j = 0; j < this.counters.length; ++j) {
                        String string = "\\" + this.object + "(" + this.instances[i] + ")\\" + this.counters[j];
                        this.counterPaths.add(string);
                    }
                }
            }
            bl = true;
        }
        return bl;
    }

    public void addCounters() {
        int n = 0;
        WinNT.HANDLEByReference hANDLEByReference = new WinNT.HANDLEByReference();
        String string = null;
        hANDLEByReference.setValue(null);
        this.handlesList = new ArrayList();
        for (int i = 0; i < this.counterPaths.size(); ++i) {
            WinNT.HANDLE hANDLE;
            hANDLEByReference.setValue(null);
            string = (String)this.counterPaths.get(i);
            n = !isEnglishLocale ? this.pdh.PdhAddEnglishCounter(this.queryHandle, string, null, hANDLEByReference) : this.pdh.PdhAddCounter(this.queryHandle, string, null, hANDLEByReference);
            if (n == 0) {
                hANDLE = hANDLEByReference.getValue();
                this.handlesList.add(hANDLE);
                continue;
            }
            hANDLE = new WinNT.HANDLE();
            this.handlesList.add(hANDLE);
        }
    }

    private double[] getValues() {
        int n = this.handlesList.size();
        double[] dArray = new double[n];
        int n2 = 0;
        this.pdh.PdhCollectQueryData(this.queryHandle);
        if (this.isSleep) {
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pdh.PdhCollectQueryData(this.queryHandle);
        }
        for (int i = 0; i < this.handlesList.size(); ++i) {
            CustomPdh.PDH_FMT_COUNTERVALUE pDH_FMT_COUNTERVALUE = new CustomPdh.PDH_FMT_COUNTERVALUE();
            pDH_FMT_COUNTERVALUE.size();
            WinNT.HANDLE hANDLE = (WinNT.HANDLE)this.handlesList.get(i);
            n2 = CustomPdh.INSTANCE.PdhGetFormattedCounterValue(hANDLE.getPointer(), this.PDH_FMT_DOUBLE | this.PDH_FMT_NOCAP100, null, pDH_FMT_COUNTERVALUE.getPointer());
            if (n2 == 0) {
                pDH_FMT_COUNTERVALUE.read();
                dArray[i] = pDH_FMT_COUNTERVALUE.Value.doubleValue;
            } else {
                dArray[i] = -5.0;
            }
            pDH_FMT_COUNTERVALUE = null;
        }
        return dArray;
    }

    public double[] getCounterValues() {
        int n = this.handlesList.size();
        double[] dArray = new double[n];
        dArray = this.getValues();
        return dArray;
    }

    public double[][] getCounterValuesForInstance() {
        int n = 0;
        double[][] dArray = new double[this.instances.length][this.counters.length];
        double[] dArray2 = this.getCounterValues();
        for (int i = 0; i < this.instances.length; ++i) {
            for (int j = 0; j < this.counters.length; ++j) {
                dArray[i][j] = dArray2[n];
                ++n;
            }
        }
        return dArray;
    }

    public void closeCounterHandles() {
        try {
            int n = 0;
            if (this.handlesList != null) {
                n = this.handlesList.size();
            }
            for (int i = 0; i < n; ++i) {
                WinNT.HANDLE hANDLE = (WinNT.HANDLE)this.handlesList.get(i);
                this.pdh.PdhRemoveCounter(hANDLE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.handlesList != null) {
            this.handlesList.clear();
        }
        if (this.counterPaths != null) {
            this.counterPaths.clear();
        }
        this.handlesList = null;
        this.counterPaths = null;
    }

    public void closeQueryHandle() {
        try {
            if (this.queryHandle != null) {
                this.pdh.PdhCloseQuery(this.queryHandle);
                this.queryHandle = null;
                this.instances = null;
                this.isSleep = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String[] discoverInstances(String string) {
        int n;
        int n2;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        String[] stringArray = null;
        String string2 = EgInstallInfo.getInstallDir() + "/lib/EnumPdhInstances.exe \"" + string + "\"";
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines(string2);
        if (arrayList == null || arrayList.size() < 2) {
            if (bl) {
                System.out.println("[CPdh] instancesList is NULL or size is ZERO so return!");
            }
            return stringArray;
        }
        ArrayList arrayList2 = (ArrayList)arrayList.get(0);
        if (arrayList2 != null) {
            n2 = arrayList2.size();
            if (n2 <= 0) {
                return null;
            }
            for (n = 0; n < n2; ++n) {
                String string3 = (String)arrayList2.get(n);
                if (string3 == null || (string3 = string3.trim()).startsWith("eG_Error:")) continue;
                int n3 = 0;
                String string4 = string3 + "#";
                for (int i = 0; i < vector.size(); ++i) {
                    String string5 = (String)vector.get(i);
                    if (!string5.equalsIgnoreCase(string3) && !string5.startsWith(string4)) continue;
                    ++n3;
                }
                if (n3 > 0) {
                    string3 = string3 + "#" + n3;
                }
                vector.addElement(string3);
            }
        }
        if ((n2 = vector.size()) <= 0) {
            return null;
        }
        stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = (String)vector.get(n);
            if (!bl) continue;
            System.out.println("[CPdh] instances[" + n + "]:" + stringArray[n]);
        }
        return stringArray;
    }

    public static void main(String[] stringArray) {
        CPdh.getSystemLocale();
        CPdh.getUserLocale();
    }
}

