/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import java.util.ArrayList;

public class CitrixICASession {
    public static String syncString = new String("CitrixICASession");
    private static CitrixICASession citrixICASessionObj = null;
    private static String object = "ICA Session";
    private static String[] counters = new String[]{"Latency - Session Average", "Latency - Session Deviation", "Input Audio Bandwidth", "Output Audio Bandwidth", "Input COM Bandwidth", "Output COM Bandwidth", "Input Drive Bandwidth", "Output Drive Bandwidth", "Input Printer Bandwidth", "Output Printer Bandwidth", "Input Session Bandwidth", "Output Session Bandwidth", "Input Session Compression", "Output Session Compression", "Input SpeedScreen Data Channel Bandwidth", "Output SpeedScreen Data Channel Bandwidth", "Input SpeedScreen Multimedia Acceleration Bandwidth", "Output SpeedScreen Multimedia Acceleration Bandwidth", "Input HDX MediaStream for Flash Data Bandwidth", "Output HDX MediaStream for Flash Data Bandwidth", "Input USB Bandwidth", "Output USB Bandwidth", "Latency - Last Recorded", "Input Session Line Speed", "Output Session Line Speed", "Input ThinWire Bandwidth", "Output ThinWire Bandwidth", "Input Seamless Bandwidth", "Output Seamless Bandwidth", "Resource Shares"};
    private ArrayList outputList = new ArrayList();
    private ArrayList outList = new ArrayList();
    private ArrayList errList = new ArrayList();
    private String[] instances = null;
    private double[][] values = null;
    private CPdh pdh = new CPdh();
    private static long lastRunTime = 0L;
    private static long cachePeriod = 10000L;
    private static ArrayList lastResults = new ArrayList();

    private CitrixICASession() {
        this.pdh.setObject(object);
        this.pdh.setCounters(counters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CitrixICASession getInstance() {
        if (citrixICASessionObj == null) {
            String string = syncString;
            synchronized (string) {
                if (citrixICASessionObj == null) {
                    citrixICASessionObj = new CitrixICASession();
                }
            }
        }
        return citrixICASessionObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getCitrixICASessionData() {
        String string = syncString;
        synchronized (string) {
            long l = System.currentTimeMillis();
            if (l - lastRunTime < cachePeriod && lastResults != null) {
                return lastResults;
            }
            this.outputList = new ArrayList();
            this.outList = new ArrayList();
            this.errList = new ArrayList();
            this.outputList.add(this.outList);
            this.outputList.add(this.errList);
            this.instances = CPdh.discoverInstances(object);
            if (this.instances != null) {
                if (!this.pdh.isValidPdhQueryHandle()) {
                    this.pdh.InitializePdh();
                }
                if (this.pdh.getCounterPathWithInstances(this.instances)) {
                    this.pdh.setSleep(true);
                    this.pdh.addCounters();
                } else {
                    this.pdh.setSleep(false);
                }
                this.values = this.pdh.getCounterValuesForInstance();
                int n = this.instances.length;
                for (int i = 0; i < n; ++i) {
                    String string2 = this.instances[i] + "=" + this.values[i][0] + "#" + this.values[i][1] + "#" + this.values[i][2] + "#" + this.values[i][3] + "#" + this.values[i][4] + "#" + this.values[i][5] + "#" + this.values[i][6] + "#" + this.values[i][7] + "#" + this.values[i][8] + "#" + this.values[i][9] + "#" + this.values[i][10] + "#" + this.values[i][11] + "#" + this.values[i][12] + "#" + this.values[i][13] + "#" + this.values[i][14] + "#" + this.values[i][15] + "#" + this.values[i][16] + "#" + this.values[i][17] + "#" + this.values[i][18] + "#" + this.values[i][19] + "#" + this.values[i][20] + "#" + this.values[i][21] + "#" + this.values[i][22] + "#" + this.values[i][23] + "#" + this.values[i][24] + "#" + this.values[i][25] + "#" + this.values[i][26] + "#" + this.values[i][27] + "#" + this.values[i][28] + "#" + this.values[i][29];
                    this.outList.add(string2);
                }
                this.outputList.set(0, this.outList);
            } else {
                this.pdh.closeCounterHandles();
                this.pdh.closeQueryHandle();
            }
            lastResults = this.outputList;
            lastRunTime = System.currentTimeMillis();
            return this.outputList;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        CitrixICASession citrixICASession = CitrixICASession.getInstance();
        if (stringArray.length == 0) {
            try {
                object = System.getenv("EGVMAGENT_INSTALL_DIR");
                if (object != null && ((String)object).trim().length() > 0) {
                    EgInstallInfo.setInstallDir((String)object);
                }
            }
            catch (Exception exception) {}
        } else {
            EgInstallInfo.setInstallDir(stringArray[0]);
        }
        object = citrixICASession.getCitrixICASessionData();
        System.out.println(object);
    }
}

