/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import java.util.ArrayList;

public class OSMemory {
    public static String syncString = new String("OSMemory");
    private static OSMemory osMemoryObj = null;
    private static String object = "Memory";
    private static String[] counters = new String[]{"Available MBytes", "Modified Page List Bytes", "Standby Cache Core Bytes", "Standby Cache Normal Priority Bytes", "Standby Cache Reserve Bytes"};
    private ArrayList outputList = new ArrayList();
    private ArrayList outList = new ArrayList();
    private ArrayList errList = new ArrayList();
    private double[] values = null;
    private EgPerfInstrumentation egPerfUtil = null;
    private static long lastRunTime = 0L;
    private static long cachePeriod = 10000L;
    private static ArrayList lastResults = new ArrayList();
    private ArrayList memoryOutputList = new ArrayList();
    private ArrayList memoryOutList = new ArrayList();
    private ArrayList memoryErrList = new ArrayList();
    private static long memoryLastRunTime = 0L;
    private static long memoryCachePeriod = 900000L;
    private static ArrayList memoryLastResults = new ArrayList();

    private OSMemory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OSMemory getInstance() {
        if (osMemoryObj == null) {
            String string = syncString;
            synchronized (string) {
                if (osMemoryObj == null) {
                    osMemoryObj = new OSMemory();
                }
            }
        }
        return osMemoryObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getOSMemoryData() {
        String string = syncString;
        synchronized (string) {
            long l = System.currentTimeMillis();
            if (l - lastRunTime < cachePeriod && lastResults != null) {
                return lastResults;
            }
            this.outputList = new ArrayList();
            this.outList = new ArrayList();
            this.errList = new ArrayList();
            this.outputList.add(this.outList);
            this.outputList.add(this.errList);
            if (this.egPerfUtil == null) {
                this.egPerfUtil = new EgPerfInstrumentation();
            }
            this.values = this.egPerfUtil.getCounterValue(object, counters);
            if (this.values == null || this.values.length < 5) {
                this.stopTest();
                lastResults = this.outputList;
                lastRunTime = System.currentTimeMillis();
                return this.outputList;
            }
            double d = this.values[0];
            double d2 = this.values[1];
            double d3 = this.values[2];
            double d4 = this.values[3];
            double d5 = this.values[4];
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            if (d3 >= 0.0) {
                d6 += d3;
            }
            if (d4 >= 0.0) {
                d6 += d4;
            }
            if (d5 >= 0.0) {
                d6 += d5;
            }
            if (d6 >= 0.0) {
                d7 = d6 / 1048576.0;
            }
            if (d >= 0.0 && d7 >= 0.0 && (d8 = d - d7) < 0.0) {
                d8 = 0.0;
            }
            EgJNAUtilities egJNAUtilities = new EgJNAUtilities();
            double d9 = egJNAUtilities.getTotalMemory();
            String string2 = "Total:" + d9;
            String string3 = "Free:" + d8;
            String string4 = "AvailablePhysicalMemory:" + d;
            String string5 = "ModifiedPageListBytes:" + d2;
            String string6 = "StandbyCacheCoreBytes:" + d3;
            String string7 = "StandbyCacheNormalPriorityBytes:" + d4;
            String string8 = "StandbyCacheReserveBytes:" + d5;
            this.outList.add(string2);
            this.outList.add(string3);
            this.outList.add(string4);
            this.outList.add(string5);
            this.outList.add(string6);
            this.outList.add(string7);
            this.outList.add(string8);
            this.outputList.set(0, this.outList);
            lastResults = this.outputList;
            lastRunTime = System.currentTimeMillis();
            return this.outputList;
        }
    }

    public ArrayList getTotalMemory() {
        long l = System.currentTimeMillis();
        if (l - memoryLastRunTime < memoryCachePeriod && memoryLastResults != null) {
            return memoryLastResults;
        }
        this.memoryOutputList = new ArrayList();
        this.memoryOutList = new ArrayList();
        this.memoryErrList = new ArrayList();
        this.memoryOutputList.add(this.memoryOutList);
        this.memoryOutputList.add(this.memoryErrList);
        EgJNAUtilities egJNAUtilities = new EgJNAUtilities();
        double d = egJNAUtilities.getTotalMemory();
        String string = "Ram:" + d;
        this.memoryOutList.add(string);
        this.memoryOutputList.set(0, this.memoryOutList);
        memoryLastResults = this.memoryOutputList;
        memoryLastRunTime = System.currentTimeMillis();
        return this.memoryOutputList;
    }

    private void stopTest() {
        if (this.egPerfUtil != null) {
            this.egPerfUtil.stop();
        }
        this.egPerfUtil = null;
    }

    public static void main(String[] stringArray) {
        Object object;
        OSMemory oSMemory = OSMemory.getInstance();
        if (stringArray.length == 0) {
            try {
                object = System.getenv("EGVMAGENT_INSTALL_DIR");
                if (object != null && ((String)object).trim().length() > 0) {
                    EgInstallInfo.setInstallDir((String)object);
                }
            }
            catch (Exception exception) {}
        } else {
            EgInstallInfo.setInstallDir(stringArray[0]);
        }
        object = oSMemory.getOSMemoryData();
        System.out.println(object);
        object = oSMemory.getTotalMemory();
        System.out.println(object);
    }
}

