/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal.axes;

import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.utils.PrefixResolver;
import com.sun.org.apache.xml.internal.utils.WrappedRuntimeException;
import com.sun.org.apache.xpath.internal.Expression;
import com.sun.org.apache.xpath.internal.ExpressionOwner;
import com.sun.org.apache.xpath.internal.XPathContext;
import com.sun.org.apache.xpath.internal.XPathVisitor;
import com.sun.org.apache.xpath.internal.axes.LocPathIterator;
import com.sun.org.apache.xpath.internal.axes.SubContextList;
import com.sun.org.apache.xpath.internal.compiler.Compiler;
import com.sun.org.apache.xpath.internal.objects.XObject;
import com.sun.org.apache.xpath.internal.patterns.NodeTest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.xml.transform.TransformerException;

public abstract class PredicatedNodeTest
extends NodeTest
implements SubContextList {
    static final long serialVersionUID = -6193530757296377351L;
    protected int m_predCount = -1;
    protected transient boolean m_foundLast = false;
    protected LocPathIterator m_lpi;
    transient int m_predicateIndex = -1;
    private Expression[] m_predicates;
    protected transient int[] m_proximityPositions;
    static final boolean DEBUG_PREDICATECOUNTING = false;

    PredicatedNodeTest(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    PredicatedNodeTest() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_predicateIndex = -1;
            this.m_predCount = -1;
            this.resetProximityPositions();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        PredicatedNodeTest predicatedNodeTest = (PredicatedNodeTest)super.clone();
        if (null != this.m_proximityPositions && this.m_proximityPositions == predicatedNodeTest.m_proximityPositions) {
            predicatedNodeTest.m_proximityPositions = new int[this.m_proximityPositions.length];
            System.arraycopy(this.m_proximityPositions, 0, predicatedNodeTest.m_proximityPositions, 0, this.m_proximityPositions.length);
        }
        if (predicatedNodeTest.m_lpi == this) {
            predicatedNodeTest.m_lpi = (LocPathIterator)predicatedNodeTest;
        }
        return predicatedNodeTest;
    }

    public int getPredicateCount() {
        if (-1 == this.m_predCount) {
            return null == this.m_predicates ? 0 : this.m_predicates.length;
        }
        return this.m_predCount;
    }

    public void setPredicateCount(int n) {
        if (n > 0) {
            Expression[] expressionArray = new Expression[n];
            for (int i = 0; i < n; ++i) {
                expressionArray[i] = this.m_predicates[i];
            }
            this.m_predicates = expressionArray;
        } else {
            this.m_predicates = null;
        }
    }

    protected void initPredicateInfo(Compiler compiler, int n) throws TransformerException {
        int n2 = compiler.getFirstPredicateOpPos(n);
        if (n2 > 0) {
            this.m_predicates = compiler.getCompiledPredicates(n2);
            if (null != this.m_predicates) {
                for (int i = 0; i < this.m_predicates.length; ++i) {
                    this.m_predicates[i].exprSetParent(this);
                }
            }
        }
    }

    public Expression getPredicate(int n) {
        return this.m_predicates[n];
    }

    public int getProximityPosition() {
        return this.getProximityPosition(this.m_predicateIndex);
    }

    @Override
    public int getProximityPosition(XPathContext xPathContext) {
        return this.getProximityPosition();
    }

    @Override
    public abstract int getLastPos(XPathContext var1);

    protected int getProximityPosition(int n) {
        return n >= 0 ? this.m_proximityPositions[n] : 0;
    }

    public void resetProximityPositions() {
        int n = this.getPredicateCount();
        if (n > 0) {
            if (null == this.m_proximityPositions) {
                this.m_proximityPositions = new int[n];
            }
            for (int i = 0; i < n; ++i) {
                try {
                    this.initProximityPosition(i);
                    continue;
                }
                catch (Exception exception) {
                    throw new WrappedRuntimeException(exception);
                }
            }
        }
    }

    public void initProximityPosition(int n) throws TransformerException {
        this.m_proximityPositions[n] = 0;
    }

    protected void countProximityPosition(int n) {
        int[] nArray = this.m_proximityPositions;
        if (null != nArray && n < nArray.length) {
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
        }
    }

    public boolean isReverseAxes() {
        return false;
    }

    public int getPredicateIndex() {
        return this.m_predicateIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executePredicates(int n, XPathContext xPathContext) throws TransformerException {
        int n2 = this.getPredicateCount();
        if (n2 == 0) {
            return true;
        }
        PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
        try {
            this.m_predicateIndex = 0;
            xPathContext.pushSubContextList(this);
            xPathContext.pushNamespaceContext(this.m_lpi.getPrefixResolver());
            xPathContext.pushCurrentNode(n);
            for (int i = 0; i < n2; ++i) {
                int n3;
                XObject xObject = this.m_predicates[i].execute(xPathContext);
                if (2 == xObject.getType()) {
                    int n4;
                    n3 = this.getProximityPosition(this.m_predicateIndex);
                    if (n3 != (n4 = (int)xObject.num())) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.m_predicates[i].isStableNumber() && i == n2 - 1) {
                        this.m_foundLast = true;
                    }
                } else if (!xObject.bool()) {
                    n3 = 0;
                    return n3 != 0;
                }
                this.countProximityPosition(++this.m_predicateIndex);
            }
        }
        finally {
            xPathContext.popCurrentNode();
            xPathContext.popNamespaceContext();
            xPathContext.popSubContextList();
            this.m_predicateIndex = -1;
        }
        return true;
    }

    @Override
    public void fixupVariables(Vector vector, int n) {
        super.fixupVariables(vector, n);
        int n2 = this.getPredicateCount();
        for (int i = 0; i < n2; ++i) {
            this.m_predicates[i].fixupVariables(vector, n);
        }
    }

    protected String nodeToString(int n) {
        if (-1 != n) {
            DTM dTM = this.m_lpi.getXPathContext().getDTM(n);
            return dTM.getNodeName(n) + "{" + (n + 1) + "}";
        }
        return "null";
    }

    public short acceptNode(int n) {
        XPathContext xPathContext = this.m_lpi.getXPathContext();
        try {
            xPathContext.pushCurrentNode(n);
            XObject xObject = this.execute(xPathContext, n);
            if (xObject != NodeTest.SCORE_NONE) {
                if (this.getPredicateCount() > 0) {
                    this.countProximityPosition(0);
                    if (!this.executePredicates(n, xPathContext)) {
                        short s = 3;
                        return s;
                    }
                }
                short s = 1;
                return s;
            }
        }
        catch (TransformerException transformerException) {
            throw new RuntimeException(transformerException.getMessage());
        }
        finally {
            xPathContext.popCurrentNode();
        }
        return 3;
    }

    public LocPathIterator getLocPathIterator() {
        return this.m_lpi;
    }

    public void setLocPathIterator(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
        if (this != locPathIterator) {
            locPathIterator.exprSetParent(this);
        }
    }

    @Override
    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getPredicate(i).canTraverseOutsideSubtree()) continue;
            return true;
        }
        return false;
    }

    public void callPredicateVisitors(XPathVisitor xPathVisitor) {
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            for (int i = 0; i < n; ++i) {
                PredOwner predOwner = new PredOwner(i);
                if (!xPathVisitor.visitPredicate(predOwner, this.m_predicates[i])) continue;
                this.m_predicates[i].callVisitors(predOwner, xPathVisitor);
            }
        }
    }

    @Override
    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        PredicatedNodeTest predicatedNodeTest = (PredicatedNodeTest)expression;
        if (null != this.m_predicates) {
            int n = this.m_predicates.length;
            if (null == predicatedNodeTest.m_predicates || predicatedNodeTest.m_predicates.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.m_predicates[i].deepEquals(predicatedNodeTest.m_predicates[i])) continue;
                return false;
            }
        } else if (null != predicatedNodeTest.m_predicates) {
            return false;
        }
        return true;
    }

    class PredOwner
    implements ExpressionOwner {
        int m_index;

        PredOwner(int n) {
            this.m_index = n;
        }

        @Override
        public Expression getExpression() {
            return PredicatedNodeTest.this.m_predicates[this.m_index];
        }

        @Override
        public void setExpression(Expression expression) {
            expression.exprSetParent(PredicatedNodeTest.this);
            ((PredicatedNodeTest)PredicatedNodeTest.this).m_predicates[this.m_index] = expression;
        }
    }
}

