/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.DownloadEngine;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.security.DeployURLClassPathCallback;
import com.sun.deploy.security.InvalidLoader;
import com.sun.deploy.security.URLClassPathControl;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.util.URLUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.ExtensionDependency;
import sun.misc.JarIndex;
import sun.misc.Resource;
import sun.misc.SharedSecrets;
import sun.misc.URLClassPath;
import sun.net.www.ParseUtil;
import sun.security.action.GetPropertyAction;

public class DeployURLClassPath
extends URLClassPath {
    static final String USER_AGENT_JAVA_VERSION = "UA-Java-Version";
    static final String JAVA_VERSION = AccessController.doPrivileged(new GetPropertyAction("java.version"));
    private static final boolean DEBUG;
    private static final boolean DEBUG2;
    private static boolean hasRealMetaIndex;
    private ArrayList path = new ArrayList();
    private Set knownUrls = new HashSet();
    final Stack urls = new Stack();
    private final List loaders = Collections.synchronizedList(new ArrayList());
    private final Map lmap = Collections.synchronizedMap(new HashMap());
    private URLStreamHandler jarHandler;
    private DeployURLClassPathCallback cb;
    private boolean isShadowClassPath = false;

    private DeployURLClassPath(URL[] uRLArray, URLStreamHandlerFactory uRLStreamHandlerFactory) {
        super(uRLArray);
        this.path.addAll(Arrays.asList(uRLArray));
        this.push(uRLArray);
        if (uRLStreamHandlerFactory != null) {
            this.jarHandler = uRLStreamHandlerFactory.createURLStreamHandler("jar");
        }
    }

    public DeployURLClassPath(URL[] uRLArray) {
        this(uRLArray, null);
    }

    public DeployURLClassPath(URLClassPath uRLClassPath) {
        this(uRLClassPath.getURLs());
    }

    public DeployURLClassPath(URL[] uRLArray, boolean bl) {
        this(uRLArray);
        this.isShadowClassPath = bl;
    }

    public String toString() {
        return "DeployURLClassPath{path=" + this.path + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addURL(URL uRL) {
        Stack stack = this.urls;
        synchronized (stack) {
            String string = URLUtil.toNormalizedString(uRL);
            if (this.knownUrls.contains(string)) {
                return;
            }
            this.knownUrls.add(string);
            this.urls.add(0, uRL);
            this.path.add(uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL[] getURLs() {
        Stack stack = this.urls;
        synchronized (stack) {
            return this.path.toArray(new URL[this.path.size()]);
        }
    }

    public void setDeployURLClassPathCallback(DeployURLClassPathCallback deployURLClassPathCallback) {
        this.cb = deployURLClassPathCallback;
    }

    public URL findResource(String string, boolean bl) {
        Loader loader;
        if (URLClassPathControl.isDisabledInCurrentThread()) {
            return null;
        }
        PathIterator pathIterator = new PathIterator();
        while ((loader = this.getLoader(pathIterator)) != null) {
            URL uRL = loader.findResource(string, bl, pathIterator);
            if (uRL != null) {
                return uRL;
            }
            pathIterator.next();
        }
        return null;
    }

    public Resource getResource(String string, boolean bl) {
        Loader loader;
        if (URLClassPathControl.isDisabledInCurrentThread()) {
            return null;
        }
        if (DEBUG2) {
            System.err.println("URLClassPath.getResource(\"" + string + "\")");
        }
        PathIterator pathIterator = new PathIterator();
        while ((loader = this.getLoader(pathIterator)) != null) {
            Resource resource = loader.getResource(string, bl, pathIterator);
            if (resource != null) {
                return resource;
            }
            pathIterator.next();
        }
        return null;
    }

    public Enumeration findResources(final String string, final boolean bl) {
        if (URLClassPathControl.isDisabledInCurrentThread()) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return new Enumeration(){
            private PathIterator pi = new PathIterator();
            private URL url = null;

            private boolean next() {
                Loader loader;
                if (this.url != null) {
                    return true;
                }
                while ((loader = DeployURLClassPath.this.getLoader(this.pi)) != null) {
                    this.url = loader.findResource(string, bl, this.pi);
                    this.pi.nextResource();
                    if (this.url == null) continue;
                    return true;
                }
                return false;
            }

            public boolean hasMoreElements() {
                return this.next();
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                URL uRL = this.url;
                this.url = null;
                return uRL;
            }
        };
    }

    public Resource getResource(String string) {
        return this.getResource(string, true);
    }

    public Enumeration getResources(final String string, final boolean bl) {
        if (URLClassPathControl.isDisabledInCurrentThread()) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return new Enumeration(){
            PathIterator pi = new PathIterator();
            private Resource res = null;

            private boolean next() {
                Loader loader;
                if (this.res != null) {
                    return true;
                }
                while ((loader = DeployURLClassPath.this.getLoader(this.pi)) != null) {
                    this.res = loader.getResource(string, bl, this.pi);
                    this.pi.nextResource();
                    if (this.res == null) continue;
                    return true;
                }
                return false;
            }

            public boolean hasMoreElements() {
                return this.next();
            }

            public Object nextElement() {
                if (!this.next()) {
                    throw new NoSuchElementException();
                }
                Resource resource = this.res;
                this.res = null;
                return resource;
            }
        };
    }

    public Enumeration getResources(String string) {
        return this.getResources(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Loader getLoader(PathIterator pathIterator) {
        if (pathIterator.found()) {
            return null;
        }
        while (this.loaders.size() < pathIterator.index() + 1) {
            Object object;
            Loader loader;
            Object object2;
            block17: {
                URL uRL;
                object2 = this.urls;
                synchronized (object2) {
                    if (this.urls.empty()) {
                        return null;
                    }
                    uRL = (URL)this.urls.pop();
                }
                object2 = URLUtil.urlNoFragString(uRL);
                if (this.lmap.containsKey(object2)) continue;
                try {
                    loader = this.getLoader(uRL);
                    object = loader.getClassPath();
                    if (object == null) break block17;
                    this.push((URL[])object);
                }
                catch (JARSigningException jARSigningException) {
                    loader = new InvalidLoader(jARSigningException, jARSigningException.getLocation());
                }
                catch (IOException iOException) {
                    Trace.ignored(iOException);
                    continue;
                }
            }
            object = this.lmap;
            synchronized (object) {
                if (this.lmap.get(object2) == null) {
                    this.loaders.add(loader);
                    this.lmap.put(object2, loader);
                } else if (loader != null) {
                    try {
                        loader.close();
                    }
                    catch (IOException iOException) {
                        Trace.ignored(iOException);
                    }
                }
            }
        }
        return (Loader)this.loaders.get(pathIterator.index());
    }

    private Loader getLoader(final URL uRL) throws IOException {
        try {
            return (Loader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String string = uRL.getFile();
                    if (string != null && string.endsWith("/")) {
                        if ("file".equals(uRL.getProtocol())) {
                            return new FileLoader(uRL);
                        }
                        return new UrlLoader(uRL);
                    }
                    return new JarLoader(uRL, DeployURLClassPath.this.jarHandler, DeployURLClassPath.this.lmap);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void push(URL[] uRLArray) {
        Stack stack = this.urls;
        synchronized (stack) {
            for (int i = uRLArray.length - 1; i >= 0; --i) {
                this.urls.push(uRLArray[i]);
            }
        }
    }

    public URL checkURL(URL uRL) {
        try {
            DeployURLClassPath.check(uRL);
        }
        catch (Exception exception) {
            return null;
        }
        return uRL;
    }

    static void check(URL uRL) throws IOException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            URLConnection uRLConnection = uRL.openConnection();
            Permission permission = URLUtil.getConnectPermission(uRL);
            if (permission != null) {
                try {
                    securityManager.checkPermission(permission);
                }
                catch (SecurityException securityException) {
                    if (permission instanceof FilePermission && permission.getActions().indexOf("read") != -1) {
                        securityManager.checkRead(permission.getName());
                    }
                    if (permission instanceof SocketPermission && permission.getActions().indexOf("connect") != -1) {
                        URL uRL2 = uRL;
                        if (uRLConnection instanceof JarURLConnection) {
                            uRL2 = ((JarURLConnection)uRLConnection).getJarFileURL();
                        }
                        securityManager.checkConnect(uRL2.getHost(), uRL2.getPort());
                    }
                    throw securityException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List closeLoaders() {
        ArrayList<Exception> arrayList = new ArrayList<Exception>();
        Map map = this.lmap;
        synchronized (map) {
            Iterator iterator = this.lmap.values().iterator();
            while (iterator.hasNext()) {
                try {
                    Loader loader = (Loader)iterator.next();
                    if (loader == null) continue;
                    loader.close();
                }
                catch (Exception exception) {
                    arrayList.add(exception);
                }
            }
            this.lmap.clear();
            this.loaders.clear();
        }
        return arrayList;
    }

    private String parseUtilEncodePath(String string, boolean bl) {
        try {
            return ParseUtil.encodePath(string, bl);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            return ParseUtil.encodePath(string);
        }
    }

    private static URL createBaseJarURL(URL uRL, URLStreamHandler uRLStreamHandler) throws IOException {
        return new URL("jar", "", -1, uRL + "!/", uRLStreamHandler);
    }

    static {
        DEBUG2 = AccessController.doPrivileged(new GetPropertyAction("sun.misc.URLClassPath.debug")) != null;
        DEBUG = DEBUG2 || Config.getPluginDebug() || Config.getDeployDebug();
        try {
            if (Class.forName("sun.misc.MetaIndex") != null) {
                hasRealMetaIndex = true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private class FileLoader
    extends Loader {
        private File dir;

        FileLoader(URL uRL) throws IOException {
            super(uRL);
            if (!"file".equals(uRL.getProtocol())) {
                throw new IllegalArgumentException("url");
            }
            String string = uRL.getFile().replace('/', File.separatorChar);
            string = ParseUtil.decode(string);
            this.dir = new File(string).getCanonicalFile();
            if (DeployURLClassPath.this.cb != null) {
                this.cpe = DeployURLClassPath.this.cb.openClassPathElement(uRL);
                this.skip = this.cpe.skip();
                this.defer = this.cpe.defer();
            }
        }

        URL findResource(String string, boolean bl, PathIterator pathIterator) {
            try {
                Resource resource = this.getResource(string, bl, pathIterator);
                if (resource != null) {
                    return resource.getURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        Resource getResource(final String string, boolean bl, PathIterator pathIterator) {
            File file;
            URL uRL;
            Serializable serializable;
            if (this.skip) {
                return null;
            }
            try {
                serializable = new URL(this.getBaseURL(), ".");
                uRL = new URL(this.getBaseURL(), DeployURLClassPath.this.parseUtilEncodePath(string, false));
                if (!URLUtil.checkTargetURL(this.getBaseURL(), uRL)) {
                    throw new SecurityException("Permission denied: " + uRL);
                }
                if (!uRL.getFile().startsWith(serializable.getFile())) {
                    return null;
                }
                if (bl) {
                    DeployURLClassPath.check(uRL);
                }
                if (string.indexOf("..") != -1) {
                    file = new File(this.dir, string.replace('/', File.separatorChar)).getCanonicalFile();
                    if (!file.getPath().startsWith(this.dir.getPath())) {
                        return null;
                    }
                } else {
                    file = new File(this.dir, string.replace('/', File.separatorChar));
                }
                if (!file.exists()) {
                    return null;
                }
            }
            catch (Exception exception) {
                return null;
            }
            if (DeployURLClassPath.this.cb != null) {
                if (this.defer) {
                    pathIterator.found(true);
                    return null;
                }
                try {
                    this.cpe.checkResource(string);
                }
                catch (SecurityException securityException) {
                    Trace.println("resource name \"" + string + "\" in " + this.dir + " : " + securityException, TraceLevel.SECURITY);
                    throw securityException;
                }
            }
            serializable = file;
            return new Resource((File)serializable){
                final /* synthetic */ File val$file;
                {
                    this.val$file = file;
                }

                public String getName() {
                    return string;
                }

                public URL getURL() {
                    return uRL;
                }

                public URL getCodeSourceURL() {
                    return FileLoader.this.getBaseURL();
                }

                public InputStream getInputStream() throws IOException {
                    return new FileInputStream(this.val$file);
                }

                public int getContentLength() throws IOException {
                    return (int)this.val$file.length();
                }
            };
        }

        void close() throws IOException {
        }
    }

    class JarLoader
    extends Loader {
        private JarFile jar;
        private URL csu;
        private URL redirectFinalBase;
        private JarIndex index;
        private URLStreamHandler handler;
        private Map lmap;
        private Attributes mainAttributes;

        JarLoader(URL uRL, URLStreamHandler uRLStreamHandler, Map map) throws IOException {
            super(DeployURLClassPath.createBaseJarURL(uRL, uRLStreamHandler));
            this.mainAttributes = null;
            this.csu = uRL;
            this.handler = uRLStreamHandler;
            this.lmap = map;
            this.ensureOpen();
        }

        JarFile getJarFile() {
            return this.jar;
        }

        private void ensureOpen() throws IOException {
            if (this.jar == null) {
                int n = ResourceProvider.get().incrementInternalUse();
                try {
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public Object run() throws IOException {
                                if (DEBUG) {
                                    System.err.println("Opening jar " + JarLoader.this.csu);
                                }
                                JarLoader.this.jar = JarLoader.this.getJarFile(JarLoader.this.csu);
                                if (hasRealMetaIndex) {
                                    JarLoader.this.index = JarIndex.getJarIndex((JarFile)JarLoader.this.jar, null);
                                } else {
                                    JarLoader.this.index = JarIndex.getJarIndex((JarFile)JarLoader.this.jar);
                                }
                                if (JarLoader.this.index != null) {
                                    String[] stringArray = JarLoader.this.index.getJarFiles();
                                    for (int i = 0; i < stringArray.length; ++i) {
                                        try {
                                            URL uRL = new URL(JarLoader.this.csu, stringArray[i]);
                                            if (!URLUtil.checkTargetURL(JarLoader.this.csu, uRL)) {
                                                throw new SecurityException("Permission denied: " + uRL);
                                            }
                                            String string = URLUtil.urlNoFragString(uRL);
                                            Map map = JarLoader.this.lmap;
                                            synchronized (map) {
                                                if (!JarLoader.this.lmap.containsKey(string)) {
                                                    JarLoader.this.lmap.put(string, null);
                                                }
                                                continue;
                                            }
                                        }
                                        catch (MalformedURLException malformedURLException) {
                                            // empty catch block
                                        }
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                    Object var4_2 = null;
                    ResourceProvider.get().decrementInternalUse(n);
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    ResourceProvider.get().decrementInternalUse(n);
                    throw throwable;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JarFile getJarFile(URL uRL) throws IOException {
            JarFile jarFile;
            Object object;
            int n = ResourceProvider.get().incrementInternalUse();
            try {
                object = (JarURLConnection)this.getBaseURL().openConnection();
                ((URLConnection)object).setRequestProperty(DeployURLClassPath.USER_AGENT_JAVA_VERSION, JAVA_VERSION);
                jarFile = ((JarURLConnection)object).getJarFile();
                Object var6_5 = null;
                ResourceProvider.get().decrementInternalUse(n);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ResourceProvider.get().decrementInternalUse(n);
                throw throwable;
            }
            object = DownloadEngine.getKnownRedirectFinalURL(this.csu);
            if (!URLUtil.sameURLs((URL)object, this.csu)) {
                this.csu = object;
                this.redirectFinalBase = DeployURLClassPath.createBaseJarURL(this.csu, this.handler);
            }
            if (DeployURLClassPath.this.cb != null) {
                this.cpe = DeployURLClassPath.this.cb.openClassPathElement(jarFile, this.csu);
                this.skip = this.cpe.skip();
                this.defer = this.cpe.defer();
            }
            return jarFile;
        }

        URL getBaseURL() {
            if (this.redirectFinalBase != null) {
                return this.redirectFinalBase;
            }
            return super.getBaseURL();
        }

        JarIndex getIndex() {
            try {
                this.ensureOpen();
            }
            catch (IOException iOException) {
                throw (InternalError)new InternalError().initCause(iOException);
            }
            return this.index;
        }

        Resource checkResource(final String string, boolean bl, final JarEntry jarEntry, final JarFile jarFile, PathIterator pathIterator) {
            URL uRL;
            try {
                uRL = new URL(this.getBaseURL(), DeployURLClassPath.this.parseUtilEncodePath(string, false));
                if (!URLUtil.checkTargetURL(this.getBaseURL(), uRL)) {
                    throw new SecurityException("Permission denied: " + uRL);
                }
                if (bl) {
                    DeployURLClassPath.check(uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
            catch (IOException iOException) {
                return null;
            }
            catch (AccessControlException accessControlException) {
                return null;
            }
            if (DeployURLClassPath.this.cb != null) {
                if (this.defer) {
                    pathIterator.found(true);
                    return null;
                }
                try {
                    this.cpe.checkResource(string);
                }
                catch (SecurityException securityException) {
                    Trace.println("resource name \"" + string + "\" in " + this.csu + " : " + securityException, TraceLevel.SECURITY);
                    throw securityException;
                }
            }
            if (Config.isJavaVersionAtLeast15()) {
                return new Resource(){

                    public String getName() {
                        return string;
                    }

                    public URL getURL() {
                        return uRL;
                    }

                    public URL getCodeSourceURL() {
                        return JarLoader.this.csu;
                    }

                    public InputStream getInputStream() throws IOException {
                        return jarFile.getInputStream(jarEntry);
                    }

                    public int getContentLength() {
                        return (int)jarEntry.getSize();
                    }

                    public Manifest getManifest() throws IOException {
                        return jarFile.getManifest();
                    }

                    public Certificate[] getCertificates() {
                        return jarEntry.getCertificates();
                    }

                    public CodeSigner[] getCodeSigners() {
                        return jarEntry.getCodeSigners();
                    }
                };
            }
            return new Resource(){

                public String getName() {
                    return string;
                }

                public URL getURL() {
                    return uRL;
                }

                public URL getCodeSourceURL() {
                    return JarLoader.this.csu;
                }

                public InputStream getInputStream() throws IOException {
                    return jarFile.getInputStream(jarEntry);
                }

                public int getContentLength() {
                    return (int)jarEntry.getSize();
                }

                public Manifest getManifest() throws IOException {
                    return jarFile.getManifest();
                }

                public Certificate[] getCertificates() {
                    return jarEntry.getCertificates();
                }
            };
        }

        URL findResource(String string, boolean bl, PathIterator pathIterator) {
            try {
                Resource resource = this.getResource(string, bl, pathIterator);
                if (resource != null) {
                    return resource.getURL();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        Resource getResource(String string, boolean bl, PathIterator pathIterator) {
            if (this.skip) {
                return null;
            }
            try {
                this.ensureOpen();
            }
            catch (IOException iOException) {
                throw (InternalError)new InternalError().initCause(iOException);
            }
            JarEntry jarEntry = this.jar.getJarEntry(string);
            if (jarEntry != null) {
                return this.checkResource(string, bl, jarEntry, this.jar, pathIterator);
            }
            if (this.index == null) {
                return null;
            }
            HashSet hashSet = new HashSet();
            return this.getResource(string, bl, hashSet, pathIterator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Resource getResource(String string, boolean bl, Set set, PathIterator pathIterator) {
            int n = 0;
            LinkedList linkedList = this.index.get(string);
            if (linkedList == null) {
                return null;
            }
            do {
                Object[] objectArray = linkedList.toArray();
                int n2 = linkedList.size();
                while (n < n2) {
                    Resource resource;
                    boolean bl2;
                    Object object;
                    JarLoader jarLoader;
                    URL uRL;
                    block20: {
                        String string2 = (String)objectArray[n++];
                        try {
                            uRL = new URL(this.csu, string2);
                            if (!URLUtil.checkTargetURL(this.csu, uRL)) {
                                throw new SecurityException("Permission denied: " + uRL);
                            }
                            String string3 = URLUtil.urlNoFragString(uRL);
                            jarLoader = (JarLoader)this.lmap.get(string3);
                            if (jarLoader != null) break block20;
                            jarLoader = (JarLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws IOException {
                                    return new JarLoader(uRL, JarLoader.this.handler, JarLoader.this.lmap);
                                }
                            });
                            object = jarLoader.getIndex();
                            if (object != null) {
                                int n3 = string2.lastIndexOf("/");
                                object.merge(this.index, n3 == -1 ? null : string2.substring(0, n3 + 1));
                            }
                            Map map = this.lmap;
                            synchronized (map) {
                                JarLoader jarLoader2 = (JarLoader)this.lmap.get(string3);
                                if (jarLoader2 == null) {
                                    this.lmap.put(string3, jarLoader);
                                } else {
                                    if (jarLoader != null) {
                                        try {
                                            jarLoader.close();
                                        }
                                        catch (IOException iOException) {
                                            Trace.ignored(iOException);
                                        }
                                    }
                                    jarLoader = jarLoader2;
                                }
                            }
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            continue;
                        }
                        catch (MalformedURLException malformedURLException) {
                            continue;
                        }
                    }
                    boolean bl3 = bl2 = !set.add(URLUtil.urlNoFragString(uRL));
                    if (!bl2) {
                        try {
                            jarLoader.ensureOpen();
                        }
                        catch (IOException iOException) {
                            throw (InternalError)new InternalError().initCause(iOException);
                        }
                        object = jarLoader.jar.getJarEntry(string);
                        if (object != null) {
                            return jarLoader.checkResource(string, bl, (JarEntry)object, jarLoader.jar, pathIterator);
                        }
                    }
                    if (bl2 || jarLoader == this || jarLoader.getIndex() == null || (resource = jarLoader.getResource(string, bl, set, pathIterator)) == null) continue;
                    return resource;
                }
            } while (n < (linkedList = this.index.get(string)).size());
            return null;
        }

        private synchronized Attributes getMainAttributes() throws IOException {
            if (this.mainAttributes == null) {
                this.ensureOpen();
                Manifest manifest = this.jar.getManifest();
                if (manifest == null) {
                    return null;
                }
                this.mainAttributes = manifest.getMainAttributes();
            }
            return this.mainAttributes;
        }

        URL[] getClassPath() throws IOException {
            if (this.index != null) {
                return null;
            }
            this.ensureOpen();
            if (!DeployURLClassPath.this.isShadowClassPath) {
                this.parseExtensionsDependencies();
            }
            if (Config.checkClassName("sun.misc.SharedSecrets")) {
                String string;
                Attributes attributes;
                if (SharedSecrets.javaUtilJarAccess().jarFileHasClassPathAttribute(this.jar) && (attributes = this.getMainAttributes()) != null && (string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                    return this.parseClassPath(this.csu, string);
                }
            } else {
                String string;
                Attributes attributes = this.getMainAttributes();
                if (attributes != null && (string = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
                    return this.parseClassPath(this.csu, string);
                }
            }
            return null;
        }

        private void parseExtensionsDependencies() throws IOException {
            String string;
            Attributes attributes = this.getMainAttributes();
            if (attributes != null && (string = attributes.getValue("Extension-List")) != null && !string.isEmpty()) {
                Trace.msgPrintln("optpkg.deprecated", new Object[]{this.csu}, TraceLevel.BASIC);
            }
            ExtensionDependency.checkExtensionsDependencies((JarFile)this.jar);
        }

        private URL[] parseClassPath(URL uRL, String string) throws MalformedURLException {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            URL[] uRLArray = new URL[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                uRLArray[n] = new URL(uRL, string2);
                if (!URLUtil.checkTargetURL(uRL, uRLArray[n])) {
                    throw new SecurityException("Permission denied: " + uRLArray[n]);
                }
                ++n;
            }
            return uRLArray;
        }

        void close() throws IOException {
            this.jar = null;
        }
    }

    static abstract class Loader {
        private final URL base;
        protected DeployURLClassPathCallback.Element cpe;
        protected boolean skip;
        protected boolean defer;

        Loader(URL uRL) {
            this.base = uRL;
        }

        URL getBaseURL() {
            return this.base;
        }

        URL[] getClassPath() throws IOException {
            return null;
        }

        abstract URL findResource(String var1, boolean var2, PathIterator var3);

        abstract Resource getResource(String var1, boolean var2, PathIterator var3);

        abstract void close() throws IOException;
    }

    private static class MetaIndex {
        private MetaIndex() {
        }

        static MetaIndex forJar(File file) {
            return null;
        }

        boolean mayContain(String string) {
            return false;
        }
    }

    static class PathIterator {
        int index;
        boolean found;

        PathIterator() {
        }

        int index() {
            return this.index;
        }

        void next() {
            ++this.index;
        }

        void nextResource() {
            ++this.index;
            this.found = false;
        }

        boolean found() {
            return this.found;
        }

        void found(boolean bl) {
            this.found = bl;
        }
    }

    private class UrlLoader
    extends Loader {
        UrlLoader(URL uRL) throws IOException {
            super(uRL);
            if (DeployURLClassPath.this.cb != null) {
                this.cpe = DeployURLClassPath.this.cb.openClassPathElement(uRL);
                this.skip = this.cpe.skip();
                this.defer = this.cpe.defer();
            }
        }

        URL findResource(String string, boolean bl, PathIterator pathIterator) {
            URL uRL;
            if (this.skip) {
                return null;
            }
            try {
                uRL = new URL(this.getBaseURL(), DeployURLClassPath.this.parseUtilEncodePath(string, false));
                if (!URLUtil.checkTargetURL(this.getBaseURL(), uRL)) {
                    throw new SecurityException("Permission denied: " + uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                URLConnection uRLConnection;
                if (bl) {
                    DeployURLClassPath.check(uRL);
                }
                if ((uRLConnection = uRL.openConnection()) instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setRequestMethod("HEAD");
                    if (httpURLConnection.getResponseCode() >= 400) {
                        return null;
                    }
                } else {
                    InputStream inputStream = uRL.openStream();
                    inputStream.close();
                }
                if (this.cpe != null) {
                    if (this.defer) {
                        pathIterator.found(true);
                        return null;
                    }
                    this.cpe.checkResource(string);
                }
                return DownloadEngine.getKnownRedirectFinalURL(uRL);
            }
            catch (SecurityException securityException) {
                Trace.println("resource name \"" + string + "\" in " + uRL + " : " + securityException, TraceLevel.SECURITY);
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }

        Resource getResource(final String string, boolean bl, PathIterator pathIterator) {
            URLConnection uRLConnection;
            URL uRL;
            if (this.skip) {
                return null;
            }
            try {
                uRL = new URL(this.getBaseURL(), DeployURLClassPath.this.parseUtilEncodePath(string, false));
                if (!URLUtil.checkTargetURL(this.getBaseURL(), uRL)) {
                    throw new SecurityException("Permission denied: " + uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("name");
            }
            try {
                if (bl) {
                    DeployURLClassPath.check(uRL);
                }
                uRLConnection = uRL.openConnection();
                InputStream inputStream = uRLConnection.getInputStream();
            }
            catch (Exception exception) {
                if (DEBUG) {
                    Trace.ignored(exception);
                }
                return null;
            }
            if (DeployURLClassPath.this.cb != null) {
                if (this.defer) {
                    pathIterator.found(true);
                    return null;
                }
                try {
                    this.cpe.checkResource(string);
                }
                catch (SecurityException securityException) {
                    Trace.println("resource name \"" + string + "\" in " + uRL + " : " + securityException, TraceLevel.SECURITY);
                    throw securityException;
                }
            }
            final boolean bl2 = !URLUtil.sameURLs(uRL, uRLConnection.getURL());
            final URL uRL2 = bl2 ? uRLConnection.getURL() : DownloadEngine.getKnownRedirectFinalURL(uRL);
            return new Resource(){
                private InputStream in;

                public String getName() {
                    return string;
                }

                public URL getURL() {
                    return uRL2;
                }

                public URL getCodeSourceURL() {
                    return uRL2;
                }

                public synchronized InputStream getInputStream() throws IOException {
                    if (this.in == null) {
                        this.in = bl2 ? new BufferedInputStream(uRLConnection.getInputStream()){
                            boolean closeCalled;

                            public void close() throws IOException {
                                if (!this.closeCalled) {
                                    this.closeCalled = true;
                                    super.close();
                                    Cache.createRedirectEntry(uRL, uRLConnection.getURL(), null);
                                }
                            }
                        } : uRLConnection.getInputStream();
                    }
                    return this.in;
                }

                public int getContentLength() throws IOException {
                    return uRLConnection.getContentLength();
                }
            };
        }

        void close() throws IOException {
        }
    }
}

